/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.GlobalPruneTimer;
import cn.hutool.cache.impl.AbstractCache;
import cn.hutool.cache.impl.CacheObj;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;

public class TimedCache<K, V>
extends AbstractCache<K, V> {
    private static final long serialVersionUID = 1L;
    private ScheduledFuture<?> pruneJobFuture;

    public TimedCache(long timeout) {
        this(timeout, new HashMap());
    }

    public TimedCache(long timeout, Map<K, CacheObj<K, V>> map2) {
        this.capacity = 0;
        this.timeout = timeout;
        this.cacheMap = map2;
    }

    @Override
    protected int pruneCache() {
        int count2 = 0;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            CacheObj co = (CacheObj)values.next();
            if (!co.isExpired()) continue;
            values.remove();
            this.onRemove(co.key, co.obj);
            ++count2;
        }
        return count2;
    }

    public void schedulePrune(long delay2) {
        this.pruneJobFuture = GlobalPruneTimer.INSTANCE.schedule(this::prune, delay2);
    }

    public void cancelPruneSchedule() {
        if (null != this.pruneJobFuture) {
            this.pruneJobFuture.cancel(true);
        }
    }
}

