/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheListener;
import cn.hutool.cache.impl.CacheObj;
import cn.hutool.cache.impl.CacheObjIterator;
import cn.hutool.cache.impl.CacheValuesIterator;
import cn.hutool.core.collection.CopiedIter;
import cn.hutool.core.lang.func.Func0;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.StampedLock;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    private static final long serialVersionUID = 1L;
    protected Map<K, CacheObj<K, V>> cacheMap;
    protected final StampedLock lock = new StampedLock();
    protected final Map<K, Lock> keyLockMap = new ConcurrentHashMap<K, Lock>();
    protected int capacity;
    protected long timeout;
    protected boolean existCustomTimeout;
    protected LongAdder hitCount = new LongAdder();
    protected LongAdder missCount = new LongAdder();
    protected CacheListener<K, V> listener;

    @Override
    public void put(K key2, V object) {
        this.put(key2, object, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key2, V object, long timeout) {
        long stamp = this.lock.writeLock();
        try {
            this.putWithoutLock(key2, object, timeout);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private void putWithoutLock(K key2, V object, long timeout) {
        CacheObj<K, V> co = new CacheObj<K, V>(key2, object, timeout);
        if (timeout != 0L) {
            this.existCustomTimeout = true;
        }
        if (this.isFull()) {
            this.pruneCache();
        }
        this.cacheMap.put(key2, co);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key2) {
        long stamp = this.lock.readLock();
        try {
            CacheObj<K, V> co = this.cacheMap.get(key2);
            if (co == null) {
                boolean bl = false;
                return bl;
            }
            if (!co.isExpired()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        this.remove(key2, true);
        return false;
    }

    public long getHitCount() {
        return this.hitCount.sum();
    }

    public long getMissCount() {
        return this.missCount.sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key2, boolean isUpdateLastAccess, Func0<V> supplier) {
        V v;
        block7: {
            v = this.get(key2, isUpdateLastAccess);
            if (null == v && null != supplier) {
                Lock keyLock = this.keyLockMap.computeIfAbsent(key2, k -> new ReentrantLock());
                keyLock.lock();
                try {
                    CacheObj<K, V> co = this.cacheMap.get(key2);
                    if (null == co || co.isExpired()) {
                        try {
                            v = supplier.call();
                        }
                        catch (Exception e2) {
                            throw new RuntimeException(e2);
                        }
                        this.put(key2, v, this.timeout);
                        break block7;
                    }
                    v = co.get(isUpdateLastAccess);
                }
                finally {
                    keyLock.unlock();
                    this.keyLockMap.remove(key2);
                }
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key2, boolean isUpdateLastAccess) {
        long stamp = this.lock.tryOptimisticRead();
        CacheObj<K, V> co = this.cacheMap.get(key2);
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                co = this.cacheMap.get(key2);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        if (null == co) {
            this.missCount.increment();
            return null;
        }
        if (!co.isExpired()) {
            this.hitCount.increment();
            return co.get(isUpdateLastAccess);
        }
        this.remove(key2, true);
        return null;
    }

    @Override
    public Iterator<V> iterator() {
        CacheObjIterator copiedIterator = (CacheObjIterator)this.cacheObjIterator();
        return new CacheValuesIterator(copiedIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CacheObj<K, V>> cacheObjIterator() {
        CopiedIter<CacheObj<K, V>> copiedIterator;
        long stamp = this.lock.readLock();
        try {
            copiedIterator = CopiedIter.copyOf(this.cacheMap.values().iterator());
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        return new CacheObjIterator<K, V>(copiedIterator);
    }

    protected abstract int pruneCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int prune() {
        long stamp = this.lock.writeLock();
        try {
            int n = this.pruneCache();
            return n;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public boolean isFull() {
        return this.capacity > 0 && this.cacheMap.size() >= this.capacity;
    }

    @Override
    public void remove(K key2) {
        this.remove(key2, false);
    }

    @Override
    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    public String toString() {
        return this.cacheMap.toString();
    }

    @Override
    public AbstractCache<K, V> setListener(CacheListener<K, V> listener) {
        this.listener = listener;
        return this;
    }

    public Set<K> keySet() {
        return this.cacheMap.keySet();
    }

    protected void onRemove(K key2, V cachedObject) {
        CacheListener<K, V> listener = this.listener;
        if (null != listener) {
            listener.onRemove(key2, cachedObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(K key2, boolean withMissCount) {
        CacheObj<K, V> co;
        long stamp = this.lock.writeLock();
        try {
            co = this.removeWithoutLock(key2, withMissCount);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
        if (null != co) {
            this.onRemove(co.key, co.obj);
        }
    }

    private CacheObj<K, V> removeWithoutLock(K key2, boolean withMissCount) {
        CacheObj<K, V> co = this.cacheMap.remove(key2);
        if (withMissCount) {
            this.missCount.increment();
        }
        return co;
    }
}

