/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.bloomfilter;

import cn.hutool.bloomfilter.BloomFilter;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.HashUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.BitSet;

public class BitSetBloomFilter
implements BloomFilter {
    private static final long serialVersionUID = 1L;
    private final BitSet bitSet;
    private final int bitSetSize;
    private final int addedElements;
    private final int hashFunctionNumber;

    public BitSetBloomFilter(int c, int n, int k) {
        this.hashFunctionNumber = k;
        this.bitSetSize = (int)Math.ceil(c * k);
        this.addedElements = n;
        this.bitSet = new BitSet(this.bitSetSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String path2, String charset) throws IOException {
        BufferedReader reader2 = FileUtil.getReader(path2, charset);
        try {
            String line;
            while ((line = reader2.readLine()) != null) {
                this.add(line);
            }
        }
        finally {
            IoUtil.close(reader2);
        }
    }

    @Override
    public boolean add(String str2) {
        int[] positions;
        if (this.contains(str2)) {
            return false;
        }
        for (int value : positions = BitSetBloomFilter.createHashes(str2, this.hashFunctionNumber)) {
            int position = Math.abs(value % this.bitSetSize);
            this.bitSet.set(position, true);
        }
        return true;
    }

    @Override
    public boolean contains(String str2) {
        int[] positions;
        for (int i : positions = BitSetBloomFilter.createHashes(str2, this.hashFunctionNumber)) {
            int position = Math.abs(i % this.bitSetSize);
            if (this.bitSet.get(position)) continue;
            return false;
        }
        return true;
    }

    public double getFalsePositiveProbability() {
        return Math.pow(1.0 - Math.exp((double)(-this.hashFunctionNumber) * (double)this.addedElements / (double)this.bitSetSize), this.hashFunctionNumber);
    }

    public static int[] createHashes(String str2, int hashNumber) {
        int[] result = new int[hashNumber];
        for (int i = 0; i < hashNumber; ++i) {
            result[i] = BitSetBloomFilter.hash(str2, i);
        }
        return result;
    }

    public static int hash(String str2, int k) {
        switch (k) {
            case 0: {
                return HashUtil.rsHash(str2);
            }
            case 1: {
                return HashUtil.jsHash(str2);
            }
            case 2: {
                return HashUtil.elfHash(str2);
            }
            case 3: {
                return HashUtil.bkdrHash(str2);
            }
            case 4: {
                return HashUtil.apHash(str2);
            }
            case 5: {
                return HashUtil.djbHash(str2);
            }
            case 6: {
                return HashUtil.sdbmHash(str2);
            }
            case 7: {
                return HashUtil.pjwHash(str2);
            }
        }
        return 0;
    }
}

