/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.tty;

import io.termd.core.function.Consumer;

public class TtyOutputMode
implements Consumer<int[]> {
    private final Consumer<int[]> readHandler;

    public TtyOutputMode(Consumer<int[]> readHandler) {
        this.readHandler = readHandler;
    }

    @Override
    public void accept(int[] data) {
        if (this.readHandler != null && data.length > 0) {
            int prev = 0;
            int ptr = 0;
            while (ptr < data.length) {
                int cp = data[ptr];
                if (cp == 10) {
                    if (ptr > prev) {
                        this.sendChunk(data, prev, ptr);
                    }
                    this.readHandler.accept(new int[]{13, 10});
                    prev = ++ptr;
                    continue;
                }
                ++ptr;
            }
            if (ptr > prev) {
                this.sendChunk(data, prev, ptr);
            }
        }
    }

    private void sendChunk(int[] data, int prev, int ptr) {
        int len = ptr - prev;
        int[] buf = new int[len];
        System.arraycopy(data, prev, buf, 0, len);
        this.readHandler.accept(buf);
    }
}

