/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.ssh.netty;

import com.alibaba.arthas.deps.io.netty.bootstrap.ServerBootstrap;
import com.alibaba.arthas.deps.io.netty.channel.Channel;
import com.alibaba.arthas.deps.io.netty.channel.ChannelFuture;
import com.alibaba.arthas.deps.io.netty.channel.ChannelInitializer;
import com.alibaba.arthas.deps.io.netty.channel.ChannelOption;
import com.alibaba.arthas.deps.io.netty.channel.ChannelPipeline;
import com.alibaba.arthas.deps.io.netty.channel.group.ChannelGroup;
import com.alibaba.arthas.deps.io.netty.channel.group.DefaultChannelGroup;
import com.alibaba.arthas.deps.io.netty.channel.socket.SocketChannel;
import com.alibaba.arthas.deps.io.netty.channel.socket.nio.NioServerSocketChannel;
import com.alibaba.arthas.deps.io.netty.handler.logging.LogLevel;
import com.alibaba.arthas.deps.io.netty.handler.logging.LoggingHandler;
import com.alibaba.arthas.deps.io.netty.util.concurrent.Future;
import com.alibaba.arthas.deps.io.netty.util.concurrent.GenericFutureListener;
import com.alibaba.arthas.deps.io.netty.util.concurrent.GlobalEventExecutor;
import io.termd.core.ssh.netty.Helper;
import io.termd.core.ssh.netty.NettyIoService;
import io.termd.core.ssh.netty.NettyIoServiceFactory;
import io.termd.core.ssh.netty.NettyIoSession;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public class NettyIoAcceptor
extends AbstractCloseable
implements IoAcceptor {
    final NettyIoServiceFactory factory;
    final ChannelGroup channelGroup;
    final NettyIoService ioService = new NettyIoService();
    private final ServerBootstrap bootstrap = new ServerBootstrap();
    private final DefaultCloseFuture closeFuture = new DefaultCloseFuture(null);
    private final Map<SocketAddress, Channel> boundAddresses = new HashMap<SocketAddress, Channel>();
    private final IoHandler handler;

    public NettyIoAcceptor(NettyIoServiceFactory factory, final IoHandler handler) {
        this.factory = factory;
        this.handler = handler;
        this.channelGroup = new DefaultChannelGroup("sshd-acceptor-channels", GlobalEventExecutor.INSTANCE);
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(factory.eventLoopGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, 100)).handler(new LoggingHandler(LogLevel.INFO))).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new NettyIoSession((NettyIoAcceptor)NettyIoAcceptor.this, (IoHandler)handler).adapter);
            }
        });
    }

    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        for (SocketAddress socketAddress : addresses) {
            this.bind(socketAddress);
        }
    }

    public void bind(SocketAddress address) throws IOException {
        InetSocketAddress inetAddress = (InetSocketAddress)address;
        ChannelFuture f = this.bootstrap.bind(inetAddress);
        Channel channel = f.channel();
        this.channelGroup.add(channel);
        try {
            f.sync();
            final SocketAddress bound = channel.localAddress();
            this.boundAddresses.put(bound, channel);
            channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

                @Override
                public void operationComplete(Future<? super Void> future) throws Exception {
                    NettyIoAcceptor.this.boundAddresses.remove(bound);
                }
            });
        }
        catch (Exception e) {
            throw Helper.toIOException(e);
        }
    }

    public void unbind(Collection<? extends SocketAddress> addresses) {
        throw new UnsupportedOperationException();
    }

    public void unbind(SocketAddress address) {
        Channel channel = this.boundAddresses.get(address);
        if (channel != null) {
            ChannelFuture fut = channel.isOpen() ? channel.close() : channel.closeFuture();
            try {
                fut.sync();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void unbind() {
        throw new UnsupportedOperationException();
    }

    public Set<SocketAddress> getBoundAddresses() {
        return new HashSet<SocketAddress>(this.boundAddresses.keySet());
    }

    public Map<Long, IoSession> getManagedSessions() {
        return this.ioService.sessions;
    }

    protected CloseFuture doCloseGracefully() {
        this.channelGroup.close().addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

            @Override
            public void operationComplete(Future<? super Void> future) throws Exception {
                NettyIoAcceptor.this.closeFuture.setClosed();
            }
        });
        return this.closeFuture;
    }

    protected void doCloseImmediately() {
        this.doCloseGracefully();
        super.doCloseImmediately();
    }
}

