/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.middleware.cli.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ReflectionUtils {
    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate " + clazz.getName(), e);
        }
    }

    public static boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1;
    }

    public static List<Method> getSetterMethods(Class<?> clazz) {
        LinkedList<Method> setters = new LinkedList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!ReflectionUtils.isSetter(method)) continue;
            setters.add(method);
        }
        return setters;
    }

    public static boolean isMultiple(Method setter) {
        Class<?> type = setter.getParameterTypes()[0];
        return type.isArray() || List.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type);
    }

    public static Class getComponentType(Method method, int index) {
        Class<?> type = method.getParameterTypes()[index];
        if (type.isArray()) {
            return type.getComponentType();
        }
        Type genericType = method.getGenericParameterTypes()[index];
        if (genericType != null) {
            return (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        Type superType = type.getGenericSuperclass();
        if (superType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)superType).getActualTypeArguments()[0];
        }
        return null;
    }
}

