/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.logger;

import java.lang.reflect.Field;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Log4j2Helper {
    private static boolean Log4j2 = false;
    private static Field configField = null;

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    private static LoggerConfig getLoggerConfig(String name) {
        if (!Log4j2Helper.hasLength(name) || "root".equalsIgnoreCase(name)) {
            name = "";
        }
        return (LoggerConfig)Log4j2Helper.getLoggerContext().getConfiguration().getLoggers().get(name);
    }

    private static LoggerContext getLoggerContext() {
        return (LoggerContext)LogManager.getContext((boolean)false);
    }

    public static Boolean updateLevel(String loggerName, String logLevel) {
        if (Log4j2) {
            Level level = Level.getLevel((String)logLevel.toUpperCase());
            if (level == null) {
                return null;
            }
            LoggerConfig loggerConfig = Log4j2Helper.getLoggerConfig(loggerName);
            if (loggerConfig == null) {
                loggerConfig = new LoggerConfig(loggerName, level, true);
                Log4j2Helper.getLoggerContext().getConfiguration().addLogger(loggerName, loggerConfig);
            } else {
                loggerConfig.setLevel(level);
            }
            Log4j2Helper.getLoggerContext().updateLoggers();
            return Boolean.TRUE;
        }
        return null;
    }

    public static Map<String, Map<String, Object>> getLoggers(String name, boolean includeNoAppender) {
        HashMap<String, Map<String, Object>> loggerInfoMap = new HashMap<String, Map<String, Object>>();
        if (!Log4j2) {
            return loggerInfoMap;
        }
        Configuration configuration = Log4j2Helper.getLoggerContext().getConfiguration();
        if (name != null && !name.trim().isEmpty()) {
            LoggerConfig loggerConfig = configuration.getLoggerConfig(name);
            if (loggerConfig == null) {
                return loggerInfoMap;
            }
            if (!name.equalsIgnoreCase("root") && Log4j2Helper.isEmpty(loggerConfig.getName())) {
                return loggerInfoMap;
            }
            loggerInfoMap.put(name, Log4j2Helper.doGetLoggerInfo(loggerConfig));
        } else {
            Map loggers = configuration.getLoggers();
            if (loggers != null) {
                for (Map.Entry entry : loggers.entrySet()) {
                    LoggerConfig loggerConfig = (LoggerConfig)entry.getValue();
                    if (!includeNoAppender) {
                        if (loggerConfig.getAppenders().isEmpty()) continue;
                        loggerInfoMap.put((String)entry.getKey(), Log4j2Helper.doGetLoggerInfo((LoggerConfig)entry.getValue()));
                        continue;
                    }
                    loggerInfoMap.put((String)entry.getKey(), Log4j2Helper.doGetLoggerInfo((LoggerConfig)entry.getValue()));
                }
            }
        }
        return loggerInfoMap;
    }

    private static Object getConfigField(LoggerConfig loggerConfig) {
        try {
            if (configField != null) {
                return configField.get(loggerConfig);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Map<String, Object> doGetLoggerInfo(LoggerConfig loggerConfig) {
        Object config;
        HashMap<String, Object> info = new HashMap<String, Object>();
        String name = loggerConfig.getName();
        if (name == null || name.trim().isEmpty()) {
            name = "root";
        }
        info.put("name", name);
        info.put("class", loggerConfig.getClass());
        CodeSource codeSource = loggerConfig.getClass().getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            info.put("codeSource", codeSource.getLocation());
        }
        if ((config = Log4j2Helper.getConfigField(loggerConfig)) != null) {
            info.put("config", config);
        }
        info.put("additivity", loggerConfig.isAdditive());
        Level level = loggerConfig.getLevel();
        if (level != null) {
            info.put("level", level.toString());
        }
        List<Map<String, Object>> result = Log4j2Helper.doGetLoggerAppenders(loggerConfig);
        info.put("appenders", result);
        return info;
    }

    private static List<Map<String, Object>> doGetLoggerAppenders(LoggerConfig loggerConfig) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map appenders = loggerConfig.getAppenders();
        for (Map.Entry entry : appenders.entrySet()) {
            HashMap<String, Object> info = new HashMap<String, Object>();
            Appender appender = (Appender)entry.getValue();
            info.put("name", appender.getName());
            info.put("class", appender.getClass());
            result.add(info);
            if (appender instanceof FileAppender) {
                info.put("file", ((FileAppender)appender).getFileName());
                continue;
            }
            if (appender instanceof ConsoleAppender) {
                info.put("target", ((ConsoleAppender)appender).getTarget());
                continue;
            }
            if (!(appender instanceof AsyncAppender)) continue;
            AsyncAppender asyncAppender = (AsyncAppender)appender;
            String[] appenderRefStrings = asyncAppender.getAppenderRefStrings();
            info.put("blocking", asyncAppender.isBlocking());
            info.put("appenderRef", Arrays.asList(appenderRefStrings));
        }
        return result;
    }

    private static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    static {
        try {
            Class<?> loggerClass = Log4j2Helper.class.getClassLoader().loadClass("org.apache.logging.log4j.Logger");
            if (loggerClass.getClassLoader().equals(Log4j2Helper.class.getClassLoader())) {
                Log4j2 = true;
            }
            try {
                configField = LoggerConfig.class.getDeclaredField("config");
                configField.setAccessible(true);
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

