/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.com.alibaba.fastjson2.writer;

import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONWriter;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.function.Function;

final class FieldWriterBigIntFunc<T>
extends FieldWriter<T> {
    final Function<T, BigInteger> function;

    FieldWriterBigIntFunc(String fieldName, int ordinal, long features, String format, String label, Field field, Method method, Function<T, BigInteger> function) {
        super(fieldName, ordinal, features, format, null, label, (Type)((Object)BigInteger.class), BigInteger.class, null, method);
        this.function = function;
    }

    @Override
    public Object getFieldValue(T object) {
        return this.function.apply(object);
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        BigInteger value = (BigInteger)this.getFieldValue(object);
        jsonWriter.writeBigInt(value, this.features);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T o) {
        long features;
        BigInteger value = this.function.apply(o);
        if (value == null && ((features = this.features | jsonWriter.getFeatures()) & JSONWriter.Feature.WriteNulls.mask) == 0L) {
            return false;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeBigInt(value, this.features);
        return true;
    }

    @Override
    public Function getFunction() {
        return this.function;
    }
}

