---
name: 语言
description: 作品的语言。
key: language
abbr: l
aliases:
  - lang
copyright: >
  除有特殊说明外，本文的简介文本复制/翻译自维基百科，遵循原始许可协议（即知识共享(Creative Commons) 署名-相同方式共享
  3.0协议）进行二次分发。


  对于标有(*)的条目，其简介文本翻译自 EHWiki，遵循原始许可协议（即 GNU 自由文档许可证）进行二次分发。


  Copyright (c) 2022 EhTagTranslation. Permission is granted to copy, distribute
  and/or modify this document under the terms of the GNU Free Documentation
  License, Version 1.2 or any later version published by the Free Software
  Foundation; with no Invariant Sections, no Front-Cover Texts, and no
  Back-Cover Texts. A copy of the license is included in the section entitled
  "GNU Free Documentation License".


  对于标有(**)的条目，其简介文本复制/翻译自萌娘百科，遵循原始许可协议（即知识共享(Creative Commons) 署名-非商业性使用-相同方式共享
  3.0 协议）进行二次分发。


  本文的其他内容，遵循知识共享(Creative Commons) 署名-非商业性使用-相同方式共享 3.0 协议提供。
rules:
  - 语言按首字母排序。
  - 语言列表参考[语言标签目录](https://ehwiki.org/wiki/language)。
example:
  raw: speechless
  name: 无言
  intro: |
    图库没有任何表示交谈或叙事意义的文字。设置该图库语言为无语言(N/A)。含有拟声词或发出声音不影响此标签。不要和`text cleaned`混淆。
  links: |
    (\*)
---

| 原始标签 | 名称 | 描述 | 外部链接 |
| -------- | ---- | ---- | -------- |
|  | == 语言标签 == |  |  |
| afrikaans | 南非语 | 南非语（Afrikaans），字面意思为“非洲语”或“非洲的”，但发展是基于欧洲语言而来，为南非境内的白人种族阿非利卡人的主要语言。也有人将其中文名译为南非荷兰语、阿非利卡语、阿非利堪斯语或斐语。由于使用南非语的欧洲移民在过去被称之为布尔人（“布尔”在荷兰语中为农民的意思），因此历史上也有人将南非语称之为布尔语。 |  |
| albanian | 阿尔巴尼亚语 | 阿尔巴尼亚语（Gjuha shqipe /ˈɟuˌha ˈʃciˌpɛ/ 或 Shqip /ʃcip/）属印欧语系。使用者约五百万人，主要分布在阿尔巴尼亚、科索沃、马其顿以及希腊。其他东南欧国家如蒙特内格罗的阿尔巴尼亚族裔亦有使用。 |  |
| arabic | 阿拉伯语 | 阿拉伯语，简称阿语（العَرَبِيَّة al-ʻarabīyah [alʕaraˈbijja] 或者 عربي/عربى ʻarabī [ˈʕarabiː]，英语：Arabic language）阿拉伯语是除英语、法语和西班牙语之外最多国家的官方语言也是联合国官方语言之一。阿拉伯语源自公元6世纪的古典阿拉伯语的一种或多种语言。它包括书面语及流通于中东、北非和非洲之角（即索马里半岛）的各种口语。阿拉伯语属于亚非语系。 |  |
| aramaic | 阿拉姆语 | 阿拉姆语（亚拉姆语：ܐܪܡܝܐ‎；亦译为亚拉姆语、亚兰语、阿拉姆语、阿拉米语、阿拉美语或阿辣米语）是闪米特语族（闪族）的一种语言，与希伯来语和阿拉伯语同属一个语族。 |  |
| armenian | 亚美尼亚语 | 亚美尼亚语（Հայերեն，转写作 Hayeren）是亚美尼亚共和国以及未得到普遍承认的纳戈尔诺-卡拉巴赫共和国的官方语言，属于印欧语系的一支，但没有任何近似语言，其38个字母的拼音系统更是独特的，不少语言学家因此对亚美尼亚语产生兴趣。亚美尼亚语目前广泛被亚美尼亚人使用。 |  |
| bengali | 孟加拉语 | 孟加拉语（bāṅlā / বাংলা 或者 bāṅālī / বাঙালী）属于印欧语系印度-伊朗语族的印度-雅利安语支，是孟加拉国和印度西孟加拉邦和特里普拉邦的官方语言，使用人口约2亿2千万人，是印度-伊朗语族在印地语之后第二大语言。孟加拉语使用主要分布于孟加拉国和印度西孟加拉邦等。 |  |
| bosnian | 波斯尼亚语 | 波斯尼亚语（bosanski / босански）是波斯尼亚和黑塞哥维那的官方语言，属于印欧语系斯拉夫语族的南斯拉夫语支，基于舒特方言。在南斯拉夫社会主义联邦共和国因为内战瓦解前，并没有波斯尼亚语这样的说法，当时塞尔维亚人、克罗地亚人与波斯尼亚人，都是使用一种称为塞尔维亚-克罗地亚语的南斯拉夫官方语言。在内战的过程当中语言也产生了变化，虽然各族群在语言上的差异极微小，但是克罗地亚人主张其语言为不同于塞尔维亚语(Srpski jezik)的克罗地亚语(Hrvatski jezik)，波斯尼亚人也开始称他们所使用的语言为波斯尼亚语。 |  |
| bulgarian | 保加利亚语 | 保加利亚语（български език; /ˈbɤ̞lgɐrski ɛˈzik/），属于印欧语系斯拉夫语族南斯拉夫语支，使用者主要集中在巴尔干半岛国家保加利亚及其周边地区，并且也是保加利亚的官方语言。 |  |
| burmese | 缅甸语 | 缅甸语（မြန်မာဘာသာ）属汉藏语系藏缅语族，以仰光音为标准。它是缅甸联邦的官方语言，在该国有大约3200万人使用，而且在孟加拉国、马来西亚、泰国、美国也有少量分布。 |  |
| catalan | 加泰罗尼亚语 | 加泰罗尼亚语或加泰兰语（Català，以下简称为加语），在某些地区又称瓦伦西亚语（Valencià）属印欧语系罗曼语族，是西班牙官方语言之一。约有12,000,000使用人口。主要位于西班牙、法国、安道尔和意大利，其中大部分使用者在加泰罗尼亚。 |  |
| cebuano | 宿务语 | 宿务语（Sinugboanon, Cebuano, Sebwano），又名米沙鄢语（Binisaya）是一种在菲律宾中部的米沙鄢群岛和南部棉兰老岛的北部的语言，属于南岛语系马来-波利尼西亚语族。根据《民族语》取得的1995年统计数字，宿务语有语言人口超过2千万人。 |  |
| chinese | 汉语 | ![无可奉告](https://tva1.sinaimg.cn/large/6c84b2d6gw1f44da2ugtrj20rs0qgair.jpg)<br>汉语，又称中文、华语、唐话，或被视为汉藏语系汉语族下之唯一一种语言，或被视为语族。 |  |
| cree | 克里语 | 克里语（英文：Cree language，平原克里语：Nēhiyawēwin / ᓀᐦᐃᔭᐍᐏᐣ）是一系列联系密切的阿尔冈昆语族方言连续体。主要使用在加拿大北部，使用人数约117,000人，是加拿大使用人数最多的原住民语言。克里语与其他八种美洲原住民语言在加拿大西北地区拥有官方语言地位。 |  |
| creole | 克里奥尔语 | 克里奥尔语（英语：Creole Language或Creole）是一种稳定的语言，由皮钦语进一步发展而成。其特征为混合多种不同语言词汇，有时也掺杂一些其他语言文法的一种语言，也称为克里奥尔语、混成语或混合语。 |  |
| croatian | 克罗地亚语 | 克罗地亚语（克罗地亚语：Hrvatski jezik）是塞尔维亚-克罗地亚语的一种标准化形式，由克罗地亚族使用，是克罗地亚的官方语言，波黑和伏伊伏丁那的官方语言之一。 |  |
| czech | 捷克语 | 捷克语（čeština）属于斯拉夫语族西斯拉夫语支的成员，属同一语支的语言还有斯洛伐克语、波兰语、波美拉尼亚语、索布语、西里西亚语等语言。捷克语的语言人口有1200万人，他们大多数都居住于捷克共和国。 |  |
| danish | 丹麦语 | 丹麦语（dansk，宽式IPA：/d̥ænsɡ̊/）属于印欧语系－日尔曼语族－北日尔曼语支，通行于丹麦王国以及其属地法罗群岛、格陵兰，也零星通行于德国、挪威和瑞典境内的部分地区。 |  |
| dutch | 荷兰语 | 荷兰语（荷兰语：Nederlands，英语：Dutch），又称尼德兰语，属于印欧语系日耳曼语族下的西日耳曼语支，主要通行于荷兰，在比利时与苏利南有六成人口使用它，这三个国家共同组成荷兰语联盟。是荷兰、比利时、苏里南和荷属安的列斯群岛的官方语言。在荷兰全境和比利时北部的佛兰德斯地区通用。 |  |
| english | 英语 | 英语（英语：English，发音ˈɪŋglɪʃ）约50多个国家做为官方或通用语言，是最广泛使用的语言，也是联合国官方语言之一。 由于超级大国美国也说英语，英语成为了事实上的国际语言。 英语在新帝国主义时代广泛传播到世界各地，是现代移民社会的主要语言。相对于所谓的英式正统英文，美式英语的文法和大量移民辞汇显得更加轻松随意，使得容易学习的美式英语反而成为现代学英语者首要选择。 |  |
| esperanto | 世界语 | ![世界语语旗](https://tva1.sinaimg.cn/large/6c84b2d6gw1f3tucq53t7j208w05xwec.jpg)<br>世界语(Esperanto)是波兰籍犹太人柴门霍夫博士(Lazarz Ludwik Zamenhof) 1887年在印欧语系基础上创立的一种语言，旨在消除国际交往中的语言障碍，令全世界各个种族肤色的人民都能在同一个人类大家庭里像兄弟姐妹一样和睦共处。世界语已经成为了目前国际上使用最为广泛的国际辅助语，全球150多个国家和地区都有世界语组织和世界语者。<br>早在1954年，联合国教科文组织就正式把国际世界语协会列为教科文组织B级咨询关系单位，确定了国际世界语协会在联合国和教科文组织的正式地位。 |  |
| estonian | 爱沙尼亚语 | 爱沙尼亚语（eesti keel）是爱沙尼亚的国语，2012年约有120万人日常使用，属于乌拉尔语系的芬兰-乌戈尔语族，最接近芬兰语，这两种语言近似到可以相通的地步——至少对于说北方方言的爱沙尼亚人是如此。同属乌戈尔语支的匈牙利语与其分别较大。其近邻立陶宛语与拉脱维亚语与爱沙尼亚语关联不大，但是爱沙尼亚语中有一部词汇为立陶宛语与拉脱维亚语的借词。 |  |
| finnish | 芬兰语 | 芬兰语（Suomi）是芬兰大部分（92%）国民的语言，也被境外芬兰裔侨民所用。它是芬兰的两种官方语言之一，也是瑞典的一种法定少数族裔语言。 |  |
| french | 法语 | 法语（le français 或 la langue française）属于印欧语系罗曼语族，法语是除英语、西班牙语和阿拉伯语之外最多国家的官方语言也是联合国工作语言之一，法语也是联合国、欧盟、北约、奥运会、世贸和国际红十字会等的官方语言及正式行政语言。 |  |
| georgian | 格鲁吉亚语 | 格鲁吉亚语（格鲁吉亚语：ქართული，转写： kartuli ena，发音：[kʰɑrtʰuli ɛnɑ]）属于南高加索语系，是格鲁吉亚的官方语言，在格鲁吉亚有三百九十万人（总人口83%）作为第一语言，另外在伊朗、土耳其、俄罗斯和美国等地，有20万人使用。 |  |
| german | 德语 | 德语（Deutsch）是印欧语系西日耳曼语支的一门语言。以使用国家数量来算是世界排名第六的语言，也是世界大国语言之一以及欧盟内使用最广的母语，德语拥有9000万到9800万使用者。 |  |
| greek | 希腊语 | 希腊语（Ελληνικά）是一种印欧语系的语言，广泛用于希腊、阿尔巴尼亚、塞浦路斯等国，与土耳其包括小亚细亚一带的某些地区。 |  |
| gujarati | 古吉拉特语 | 古吉拉特语（ગુજરાતી，拉丁化：Gujarātī）属于印欧语系印度-伊朗语族的印度-雅利安语支，为印度22种官方语言与14种地区性语言之一，同时也是巴基斯坦少数民族语言。全球有大约4600万人讲这种语言，为世界上第23大语言。从使用的人群主要分布来看，印度4550万，乌干达15万，巴基斯坦10万，肯尼亚5万。 |  |
| hebrew | 希伯来语 | 希伯来语（עִבְרִית‘Ivrit，读音：[iv'ri:t]）属于亚非语系闪米特语族，为具有古代犹太民族（以色列民族或希伯来民族）意识之现代人民的民族语言、也是犹太教的宗教语言。 |  |
| hindi | 印地语 | 印地语（天城文：हिन्दी 或 हिंदी，拉丁字母转写：Hindī）又称北印度语，是印欧语系印度-伊朗语族中印度-雅利安语支下的一种语言。印地语以使用国家数量来算是世界排名第八的语言，在1965年1月26日成为印度中央政府的官方语言（连同英语）。 |  |
| hmong | 苗语 | 苗语是苗族人语言的统称，属于苗瑶语族的苗语支。分布在中国的湖南、四川、贵州、云南等地；以及越南、老挝、泰国、美国等国。苗语可以分为湘西（100万人）、黔东（210万人）和川黔滇（300多万人）三大方言。其中以川黔滇方言最为复杂。这三大方言与布努语等语言共同组成苗语支。 |  |
| hungarian | 匈牙利语 | 匈牙利语又称马扎尔语，是一种乌拉尔语系芬兰－乌戈尔语族乌戈尔语支的语言，为马扎尔人的语言。使用者主要分布在匈牙利，是该国的官方语言，也是欧盟24个官方语言之一。此外匈牙利语还分布在罗马尼亚、斯洛伐克、乌克兰、塞尔维亚、克罗地亚、奥地利、斯洛文尼亚等国家。 |  |
| icelandic | 冰岛语 | 冰岛语（íslenska），属于日耳曼语族的斯堪的那维亚语支（北日耳曼语支），现代冰岛的官方语言。源自古代北欧人亦即维京人使用的语言（或称古诺斯语）。现代冰岛语是与古诺尔斯语离异最少的分支，其发音法（尤其是母音音素），是北日耳曼语支当中改变最少的。自维京人在近一千年前，将古诺斯语带到冰岛并形成冰岛语后，由于冰岛语词汇的拼法同语法变化不大，其标准化的写法基于自古诺尔斯语音位系统、在语义与词汇顺序上细微的拼写差异。所以，现代冰岛人或懂得冰岛语的人不须花太多时间即能方便地阅读及能理解维京时代的古代文学作品或冰岛的古代文学作品。 |  |
| indonesian | 印尼语 | 印尼语（bahasa Indonesia），即印尼化的马来语廖内方言，是印度尼西亚的官方语言。属马来-波利尼西亚语族。全世界大约有4280万人使用这种语言，还有1.55亿人将印尼语作为第二语言。 |  |
| irish | 爱尔兰语 | 爱尔兰语（Gaeilge na hÉireann），又称盖尔语、爱尔兰盖尔语，爱尔兰语在语言分类上属于印欧语系的凯尔特语族，和同属该语族的布列塔尼语、威尔士语、以及苏格兰盖尔语有相当密切的关系。虽然爱尔兰语是爱尔兰共和国的官方语言，同时也是北爱尔兰官方承认的区域语言，而英语为第二官方语言，但是英语却为绝大多数爱尔兰人的母语，爱尔兰语作为主要语言的通行范围限于西海岸的一些地区。 |  |
| italian | 意大利语 | 意大利语（意大利语：Italiano）隶属于印欧语系的罗曼语族。现有约7千万人日常用意大利语，大多是意大利居民。另有28个国家使用意大利语，其中4个立它为官方语言。 |  |
| japanese | 日语 | 日本语（日本語／にほんご Nihongo），简称日语，其文字称为日文，是一种主要为日本列岛上大和族所使用的语言，日语也是大国语言之一。虽然日本并没有在法律上明确规定其官方语言，但是各种法令都规定要使用日语，在学校教育中作为国语教授的也是日语。日语是日本的公用语言是不争的事实。<br><br>在 E-Hentai 中，日语作为默认语言选项不应填写，仅在图库官方为多语言且包含日语、或由其他语言翻译为日语时使用此标签。 |  |
| javanese | 爪哇語 | 爪哇语（ꦧꦱꦗꦮ, Basa Jawa）是印尼四大主岛之一的爪哇岛上东、中部居民主要采用的语言。爪哇语属南岛语系中马来-波利尼西亚语族的一个语支，和印尼语及马来语算是近亲，有语言人口7550万人。不少讲爪哇语的人都同时会说印尼语，但日常生活主要采用爪哇语。 |  |
| kannada | 卡纳达语 | 卡纳达语（卡纳达语：ಕನ್ನಡ，[ˈkʌnːəɖɑː]），又译坎纳达语、康纳达语、埃纳德语（ಕನ್ನಡ kannaḍa），是印度卡纳塔克邦的官方语言，属于达罗毗荼语系。 |  |
| kazakh | 哈萨克语 | 哈萨克语（қазақ тілі，qazaq tili，قازاق ٴتىلى，pronounced [qɑˈzɑq tɘˈlɘ]），简称哈语，属突厥语系，是哈萨克族所使用的语言。与其他属突厥语系的民族语言相当接近。日常交际，与其语言属突厥语系的其他民族，如维吾尔族、柯尔克孜族、塔塔尔族以及乌孜别克族均不会产生太大的障碍，一般不需要翻译，尤其与吉尔吉斯语和卡拉卡尔帕克语非常相近。据说哈萨克语言是受乌孙语、突厥语以及蒙古语影响的综合产物。 |  |
| khmer | 高棉语 | 高棉语（高棉语：ភាសាខ្មែរ，高棉语发音：[pʰiːəsaː kmaːe]，正式的称呼为 ខេមរភាសា kheemaʾraʾ phiăsaa 高棉语发音：[kʰeː.maʔ.raʔ pʰiə.ˈsaː]）是高棉族的语言，亦是以高棉人为主体民族的柬埔寨的官方语言和通用语言，故亦称柬埔寨语、柬语。高棉语属于南亚语系孟-高棉语族。在柬埔寨，约有1300万人以高棉语为母语，约100万人以高棉语为第二语言；在泰国、老挝和越南也有约200万的使用者，以当地高棉人为主。 |  |
| korean | 韩语 | 朝鲜语（조선어／朝鮮語），韩国称韩国语（한국어／韓國語），是通行于韩国、朝鲜及中国东北、俄罗斯远东地区、日本等朝鲜族聚居地区的语言。 |  |
| kurdish | 库尔德语 | 库尔德语（کوردی, Kurdî‎ [ˈkuɾdiː]）是库尔德人使用的语言，母语人口主要在伊朗西北部和土耳其东南部（参看库尔德斯坦），伊拉克、叙利亚亦有不少分布。属伊朗语支三大分支的西北语支，与属西南语支的波斯语不同。 |  |
| ladino | 犹太西班牙语 | 犹太西班牙语（西班牙语：judeoespañol；希伯来语：גודיאו-איספאנייול‎），又称作拉迪诺语（Ladino）、Judezmo、Espanyol、Spaniolit等，是一个源自于中世纪西班牙语的罗曼语言，使用者主要是塞法迪犹太人。身为犹太后裔使用的语言，犹太西班牙语融合了希伯来语和亚拉姆语，尚受到阿拉伯语、土耳其语和少部分希腊语等语言的影响，因为塞法迪犹太人在奥图曼帝国时期流亡时经过这些地方。 |  |
| lao | 老挝语 | 老挝语（ພາສາລາວ phasa lao），又称寮语、寮国语、老语，属壮侗语系侗台语族壮傣语支，是老挝的官方语言。其使用人口约520万，主要分布于老挝，以及泰国东北部和北部的佬族居住地区，是佬族的通用语。 |  |
| latin | 拉丁语 | 拉丁语（拉丁语：lingua latīna，IPA：[ˈlɪŋɡʷa laˈtiːna]），是印欧语系的意大利语族语言，于古罗马广泛使用，至少可追溯至罗马帝国的奥古斯都皇帝时期，当时所使用的书面语称为“古典拉丁语”。拉丁语是最早在拉提姆地区（今意大利的拉齐奥区）和罗马帝国使用的语言之一。虽然现在拉丁语通常被认为是一种死语言，但仍有少数基督宗教神职人员及学者可以流利地使用拉丁语。罗马天主教传统上用拉丁语作为正式会议的语言和礼拜仪式用的语言，此外，许多西方国家的大学仍然提供有关拉丁语的课程。 |  |
| latvian | 拉脱维亚语 | 拉脱维亚语（latviešu valoda），是拉脱维亚的官方语言。在拉脱维亚有大约130万人以其为母语，而在海外有约10万。总共有200万，也即80%的拉脱维亚人口使用拉脱维亚语。而在其中有116万，也即约56%的人在国内将其当作主要语言。在日常生活中使用拉脱维亚语的比例在多个地区均有上升趋势。 |  |
| marathi | 马拉地语 | 马拉地语（मराठी Marāṭhī、Marathi language） 是印度的22种规定语言之一，在马哈拉施特拉邦大约有 9 千万使用者。 |  |
| mongolian | 蒙古语 | 蒙古语是蒙古民族说的语言，属于阿尔泰语系蒙古语族。蒙古语有很多方言，主要分为中部方言、西部方言（卫拉特语）、北部方言（布里亚特语）和东部方言（科尔沁-喀喇沁）。蒙古语接近辽国的契丹语，但是由于契丹文尚未完全解读，很难进行语言历史比较。 |  |
| ndebele | 恩德贝莱语 | 恩德贝莱语（恩德贝莱语：Sindebele saseNyakatho）是班图语支的一种语言，使用人群主要分布在南非的林波波省、姆普马兰加省和津巴布韦等，在南非的西北省也有少数恩德贝莱语的使用者，在南非的恩德贝莱语称为南恩德贝莱语，在津巴布韦的恩德贝莱语称为北恩德贝莱语，它深受斯威士语的影响，在某种程度上也受北索托语的影响。 南恩德贝莱语是南非的官方语言，但使用范围也不是很广。 |  |
| nepali | 尼泊尔语 | 尼泊尔语属印度-雅利安语支，在尼泊尔、不丹、印度和缅甸的一些地区使用。是尼泊尔的官方语言。大概一半的尼泊尔人使用尼泊尔语作为其母语，其他尼泊尔人将其作为第二语言。使用范围包括东尼泊尔，直到印度领土北安查尔邦和喜马偕尔邦。 |  |
| norwegian | 挪威语 | 挪威语（norsk）是日耳曼语族的一个分支，普遍通用于挪威，也是挪威的官方语言。挪威语与瑞典语和丹麦语十分相似，操这三种语言的人也可以互相沟通。由于丹麦语从十六世纪至十九世纪期间一直是挪威地区的标准书写语言，以致近代的挪威语发展一直都受著爱国主义、城乡隔阂以及挪威文学史的争议所影响。 |  |
| oromo | 奥罗莫语 | 奥罗莫语（Oromoo，又称：阿方奥罗莫语 Afaan Oromoo，旧称盖拉语 Galla）为一种库希特语（Cushitic），属于亚非语系库希特语族，为非洲东北部国家埃塞俄比亚中西部的通行语言。奥罗莫语也使用在伊索比亚的北部，并及于索马里、苏丹、肯亚和埃及等地区。原先与伊索比亚的阿姆哈拉语一样使用吉兹字母来拼写，自1991年开始被“奥罗莫解放阵线”（OLF）定案，由吉兹字母改为用26个拉丁字母来拼音。 |  |
| papiamento | 帕皮阿门托语 | 帕皮阿门托语（在阿鲁巴称为Papiamento，在博奈尔和库拉索则称为Papiamentu），又称帕皮亚门托语，是流行于荷属加勒比地区阿鲁巴岛、博奈尔岛和库拉索岛三座岛屿的一种克里奥尔语，也是这三座岛的官方语言之一。 |  |
| pashto | 普什图语 | 普什图语（普什图语：پښتو‎，转写：Pax̌tō，国际发音：[ˈpəʂt̪oː, ˈpəçt̪oː, ˈpʊxt̪oː]），帕图语，是中亚和南亚地区普什图族民族语言，在文献上又称作阿富汗语(افغاني‎, Paṭhānī)，属于印欧语系东伊朗语支的成员。普什图语与达利语同为阿富汗的两种官方语言，并且在巴基斯坦西部和西北部地区属于使用人数第二多的语言。方言差距很大，没有势力较强的标准音，因此各地普什图人交流并不容易。而且很多普什图人通常也会操达利语。 |  |
| persian | 波斯语 | 波斯语（فارسی / Fārsī‎），属于印欧语系印度-伊朗语族伊朗语支，是一种形成于8至9世纪间的文学语言。是今天伊朗的官方语言，作为其分支的达利语和塔吉克语分别是阿富汗和塔吉克斯坦的官方语言。由于历史与宗教的原因，现代波斯语中，有近60%的词汇来自属于闪含语系的阿拉伯语。波斯语用波斯-阿拉伯字母拼写。 |  |
| polish | 波兰语 | 波兰语（język polski）是波兰的官方语言。也是西斯拉夫语支中使用人数最多的语种。 |  |
| portuguese | 葡萄牙语 | 葡萄牙语（葡语：Português）是罗曼语族的一种语言。葡语以使用国家数量来算是世界排名第七的语言，使用地区包括葡萄牙、巴西、安哥拉、莫桑比克、佛得角、圣多美和普林西比、几内亚比索、东帝汶和澳门，共计九个国家或地区。超过两亿人口以葡萄牙语为母语。 |  |
| punjabi | 旁遮普语 | 旁遮普语，也译彭加语（旁遮普语古木基文：ਪੰਜਾਬੀ，Shahmukhi字母：پنجابی）属于印欧语系印度-伊朗语族的印度-雅利安语支。旁遮普语特殊的是，第一，有声调；第二，是黏着语。旁遮普语又会分为西旁遮普语、Lehnda(ਲੇਹੰਦਾ)或Lahnda(ਲਹਿੰਦਾ) 和东旁遮普语。Siraiki和Hindko通常也被视为旁遮普语的方言。 |  |
| romanian | 罗马尼亚语 | 罗马尼亚语（limba română，国际音标：/'limba ro'mɨnə/）属于罗曼语族的东罗曼语支。它是罗马尼亚和摩尔多瓦的官方语言，被大约两千四百万人当作母语，其中大部分聚集在罗马尼亚和摩尔多瓦两国，同时也有大约四百万人把罗马尼亚语当作第二语言。罗马尼亚语也是欧盟的官方语言之一。 |  |
| russian | 俄语 | 俄语（俄语：ру́сский язы́к，罗马化：russkij jazyk，发音[ˈruskʲɪj jɪˈzɨk]）俄语为联合国官方语言之一。俄语属于斯拉夫语族的东斯拉夫语支，是斯拉夫语族中使用人数最多的语言，是俄罗斯、白俄罗斯、吉尔吉斯斯坦及哈萨克斯坦的官方语言，主要在俄罗斯等前苏联加盟共和国中使用，且在华约的成员国里曾经被学校广泛列为第一外语教学。 |  |
| sango | 桑戈语 | 桑戈语是中非共和国的主要语言，是约500万人的母语。包括William J. Samarin在内的一些语言学家把他归为一种基于恩巴恩迪语的克里奥尔语。但是Marcel Diki-Kidiri、Charles H. Morrill等人则认为桑戈语中的结构变化不需要用克里奥尔化过程来解释。 |  |
| sanskrit | 梵语 | 梵语（梵语：संस्कृता वाक्，saṃskṛtā vāk，简称संस्कृतम्，saṃskṛtam；英语：Sanskrit；亦称 梵志）是印欧语系的印度-伊朗语族的印度-雅利安语支的一种语言，是印欧语系最古老的语言之一。和拉丁语一样，梵语已经成为一种属于学术和宗教的专门用语。虽然现代梵语的母语使用者非常少，但是因为梵文本身的特殊性，在现代佛教、印度教和耆那教的经典中依然可以随处找到梵语。 |  |
| serbian | 塞尔维亚语 | 塞尔维亚语（српски）是塞尔维亚-克罗地亚语的一种标准化形式。 |  |
| shona | 绍纳语 | 绍纳语（修纳语：ChiShona），也译作修纳语，是属于班图语支的一种语言。是赞比亚南部与津巴布韦绍纳人的母语，也是津巴布韦的官方语言之一。 |  |
| slovak | 斯洛伐克语 | 斯洛伐克语（slovenský jazyk / slovenčina）属于印欧语系斯拉夫语族西斯拉夫语支，同波兰语和捷克语以及索布语相近，特别是跟捷克语的使用者可以无障碍的交流。斯洛伐克语主要使用在斯洛伐克，其次使用于捷克和塞尔维亚。 |  |
| slovenian | 斯洛文尼亚语 | 斯洛文尼亚语（slovenski jezik 或 slovenščina），属印欧语系斯拉夫语族，为斯洛文尼亚的官方语言，在全球有约2百万使用者，分为6种互不相通的方言。斯洛文尼亚语比较接近塞尔维亚-克罗地亚语。 |  |
| somali | 索马里语 | 索马里语（索马里语：Af-Soomaali [æ̀f sɔ̀ːmɑ́ːlì]）属于闪含语系库希特语族，为非洲东部国家索马里的官方语言。索马里语也使用在埃塞俄比亚、苏丹及肯尼亚等地区。1922年后索马里开始采用由奥斯曼·尤瑟夫·肯纳迪所研创的奥斯曼亚字母来拼写，在1960年代时奥斯曼亚字母与拉丁字母两者并行使用。自1972年起全面采用拉丁字母来拼写，不过在一些私人及特殊场合也会用奥斯曼亚字母的书写法。 |  |
| spanish | 西班牙语 | 西班牙语（Español），也称卡斯特亚诺语（Castellano），简称西语，西班牙语是除英语、法语和阿拉伯语之外最多国家的官方语言也为联合国官方语言之一。西班牙语起源于西班牙卡斯蒂利亚的语文，为罗曼语族的分支。除了发源地西班牙之外，使用者主要集中在拉丁美洲国家，约有4亿人使用。 |  |
| swahili | 斯瓦希里语 | 瓦希里语（kiswahili），是黏着语，属于班图语族，是非洲语言使用人数最多的语言之一（5500万多人），与阿拉伯语及豪萨语并列非洲三大语言。斯瓦希里语是坦桑尼亚、肯尼亚、乌干达的官方语言，刚果民主共和国的国家语言之一，斯瓦希里语的方言科摩罗语是科摩罗的官方语言之一。在赞比亚、马拉维、布隆迪、卢旺达、莫桑比克等东非和中非的国家，斯瓦希里语被作为交际语言使用。在1728年后斯瓦希里语是以阿拉伯字母来拼写，之后到19世纪受到欧洲殖民者的影响改以拉丁字母来拼音。而斯瓦希里语也吸收了大量阿拉伯语借词，语言的名称“斯瓦希里”来自阿拉伯文سواحيل（Sawahil）“濒海地区”。 |  |
| swedish | 瑞典语 | 瑞典语（svenska）是北日耳曼语（也称为斯堪的那维亚语）的一种，主要使用地区为瑞典、芬兰（尤其是奥兰岛），使用人数超过九百万人。它和斯堪的那维亚地区另外两种语言——丹麦语和挪威语——是相通语言。和其它北日耳曼语一样，瑞典语来源于古诺尔斯语。古诺尔斯语是维京时期斯堪的那维亚地区通用语言。 |  |
| tagalog | 他加禄语 | 他加禄语（Wikang Tagalog），又称为他加洛语、塔加洛语和塔加路语，在语言分类上属于南岛语系的马来-玻里尼西亚语族，主要于菲律宾吕宋岛使用。菲律宾的国语之一菲律宾语（英语为另一官方语言或第二语言），正是以他加禄语为主体发展而来的。 |  |
| tamil | 泰米尔语 | 泰米尔语（தமிழ் Tamiḻ）是一种有超过二千年历史的语言，属于达罗毗荼语系，通行于印度南部、斯里兰卡东北部。它是泰米尔纳德邦和本地治里的官方语言。在印度洋及南太平洋不少印度裔居民也是说泰米尔语的，他们散布于马达加斯加、毛里求斯、斐济等地。根据统计，在1996年，泰米尔语在全球的语言人口中排第18位，有语言人口7400万人。泰米尔语这个名称相信来自梵文“Dravida”（达罗毗荼）的读音变化。泰米尔语有超过2000年的文学传统，而不同于欧洲的拉丁文和罗曼语族，这个传统一直没有断过。犹如中文的文言文一样，至今古泰米尔文还在日常生活中继续被使用。例如，泰米尔小学生一直到现在还用1世纪的字母韵文 átticúdi 来学字母。 |  |
| telugu | 泰卢固语 | 泰卢固语（తెలుగు）是印度安得拉邦的官方语言，属于达罗毗荼语系，是印度六大传统语言之一。泰卢固语是印度安得拉邦泰卢固人的语言，印度宪法承认的语言之一。属达罗毗荼语系中部语族。在印度的使用泰卢固语为母语的人数排名第三（7400万为母语，总数8千万，2001年人口普查），居同语系各语言之首。 |  |
| thai | 泰语 | 泰语，又称中部泰语（ภาษาไทย，转写：phasa thai，国际音标：[pʰāːsǎːtʰāj]），旧称暹罗语或阿瑜陀耶语（现仍偶有使用），属壮侗语系侗台语族，是泰国的官方语言。它是一种分析型的声调语言。 |  |
| tibetan | 藏语 | 藏语（藏文：བོད་སྐད་，藏语拼音：poigê，威利：bod skad，THL：Böké），属汉藏语系藏缅语族藏语支，是以藏族为主的喜马拉雅文化圈使用的主要语言。藏语使用区分布在中国西藏自治区，青海省，四川省的阿坝藏族羌族自治州、甘孜藏族自治州、木里藏族自治县，甘肃省的甘南藏族自治州和云南省的迪庆藏族自治州等若干区域。巴基斯坦、印度、尼泊尔、不丹四个国家也有藏语使用者分布。 |  |
| tigrinya | 提格雷尼亚语 | 提格雷尼亚语（ትግርኛ, tigriññā）是一种闪语族的语言，主要是由厄立特里亚中部和埃塞俄比亚北部的提格雷州的提格雷尼亚人的族群所使用，是当地的官方语言亦是厄立特里亚两种主流语言之一，并为从当地移居到外地的居民，包括部分现在以色列定居的贝塔以色列部落日常所使用的语言。 |  |
| turkish | 土耳其语 | 土耳其语（Türkçe；[t̪yɾktʃe]）是一种现有6500万到7300万人使用的语言，属于阿尔泰语系突厥语族，主要在土耳其本土使用，并通行于阿塞拜疆、塞浦路斯、希腊、马其顿、罗马尼亚、乌孜别克和土库曼斯坦，以及在西欧居住的数百万土耳其裔移民（主要集中在德国）。土耳其语是突厥语族诸语中使用人数最多语言。 |  |
| ukrainian | 乌克兰语 | 乌克兰语（українська мова）是斯拉夫语族东斯拉夫语支的一种语言。它是乌克兰的官方语言，同时也是乌克兰两种主要通用语言之一。乌克兰文采用西里尔字母，所用字母同俄文有一定区别。乌克兰语使用人数有4700万，在斯拉夫语族中，仅次于俄语和波兰语。 |  |
| urdu | 乌尔都语 | 乌尔都语（乌尔都语：اُردُو‬）是属于印欧语系印度-伊朗语族的印度-雅利安语支。从使用人数来看，乌尔都语大约排名世界第20名，是巴基斯坦的国语，也是印度的24种规定语言之一。如果从宏观角度来看，乌尔都语可看成是印度斯坦语的一部分，所有印度斯坦语言构成世界上第四大的语言。在1200年到1800年，南亚在德里苏丹国和莫卧儿帝国的统治下，乌尔都语受到波斯语，突厥语，库尔德语和阿拉伯语的影响。 |  |
| vietnamese | 越南语 | 越南语（Tiếng Việt／㗂越）又称越语（Việt Ngữ／越語）、京语（Tiếng Kinh／㗂京）及国语（Quốc Ngữ／國語），除此之外，还有一个现代少用的前法国殖民地名称安南语（Tiếng An Nam／㗂安南）。越南语是越南的国家语言，有85至90%的越南人将之作为母语，另外居住在海外的3百万越侨、住在中国广西的京族亦使用越南语。历史上，越南语曾经使用汉字与喃字表记（即汉喃文），现代则使用以拉丁字母为基础，添加若干个新字母及声调符号的国语字（Chữ Quốc Ngữ／𡨸國語）书写。 |  |
| welsh | 威尔士语 | 威尔士语（Cymraeg [kʰəmˈraiɡ]，或y Gymraeg 威尔士语发音：[ə ɡəmˈraiɡ]）是英国威尔士的传统语言，属于凯尔特语族，接近布列塔尼语和康沃尔语。 |  |
| yiddish | 意第绪语 | 意第绪语（ייִדיש yidiš，又译“依地语”）属于日耳曼语族。全球大约有三百万人在使用，大部分的使用者是犹太人，而且其中主要是阿什肯纳兹犹太人在操用此语。意第绪（语）这个称呼本身可以来代表“犹太人”（跟德语的“犹第绪”(jüdisch)一词来比较），也可能是“意第绪-塔乌特绪”（ייִדיש־טײַטש, yidish-taitsh）的简称，或者说是用作表示“德国犹太人”的称呼。在“意第绪（语）”称呼于13至14世纪的早年发展阶段，它也是被当作“德国犹太人”的意思；在早先时期有时候“意第绪”，亦如它以后所表示的意思，也被视“意第绪语”为这种语言的名称来看待。 |  |
| zulu | 祖鲁语 | 祖鲁语（祖鲁语：isiZulu）是祖鲁人所使用的一种语言。目前大约有九百万人使用，其中95%居住在南非共和国境内。祖鲁语是24%的南非人的母语，也是南非最大的语言。大约50%的南非人可以听懂祖鲁语(Ethnologue 2005)。在种族隔离结束后的1994年，祖鲁语成为南非的11种官方语言之一。 |  |
|  | == 技术性标签 == |  |  |
| speechless | 无言 | 图库没有任何表示交谈或叙事意义的文字。设置该图库语言为无语言（N/A）。<br>含有拟声词或发出声音不影响此标签。不能在`imageset`、`gamecg`和没有清晰描绘一系列事件（即没有视觉叙事）的作品中使用此标签。不应与`text cleaned`混淆。 | (\*) |
| text cleaned | 文字清除 | 去除了漫画或 CG 集上的文字。<br>不用于同时包含无字版本和文字版本的图库。不应与`speechless`混淆。 | (\*) |
| translated | 翻译 | 任何由第三方从原始语言翻译的版本。<br>需要一个语言标签。任何由作品创作者添加或直接批准的文字都被视为他们自己的文字。 | (\*) |
| rewrite | 改写 | 替换了原有的文字或在没有文字的图库添加了文字。<br>需要一个语言标签。不用于`rough translation`。 | (\*) |
