(ns metabase.util.malli.registry-test-macro)

(defmacro with-returning-cache-miss-count
  "Returns the number of cache misses that occurred while executing `body`.
    This is useful for testing that the cache is working as expected, especially
    when you want to ensure that certain schemas are not cached.

    Counting cache misses this way is reliable in a multi-threaded context. (`*cache-miss-hook*` will be thread-local,
    so you only see the misses generated by your own `body`).

    Counting them using the `mr/cache` atom is not! so use this to avoid flakes."
  [& body]
  `(let [cache-misses# (atom 0)]
     (binding [mr/*cache-miss-hook* (fn [_# _# _#] (swap! cache-misses# inc))]
       ~@body)
     @cache-misses#))
