import { isRootCollection } from "metabase/collections/utils";
import type { Collection, CollectionId } from "metabase-types/api";

type GetCollectionListProps = {
  collection: Collection;
  baseCollectionId?: CollectionId | null;
};

export const getCollectionList = ({
  baseCollectionId = null,
  collection,
}: GetCollectionListProps) => {
  // baseCollectionId can be either a numeric or entity id
  if (
    baseCollectionId &&
    (collection.id === baseCollectionId ||
      collection.entity_id === baseCollectionId)
  ) {
    return [];
  }

  const ancestors = collection.effective_ancestors || [];
  const hasRoot = ancestors[0] && isRootCollection(ancestors[0]);
  const [_root, ...crumbsWithoutRoot] = ancestors;

  const baseIndex = baseCollectionId
    ? ancestors.findIndex((part) => part.id === baseCollectionId)
    : -1;

  if (baseIndex >= 0) {
    return ancestors.slice(baseIndex);
  } else {
    return hasRoot ? crumbsWithoutRoot : ancestors;
  }
};
