import MetabaseSettings from "metabase/lib/settings";
import { loadSettings } from "metabase/redux/settings";
import type {
  EnterpriseSettings,
  PasswordResetTokenStatus,
} from "metabase-types/api";

import { Api } from "./api";

export const sessionApi = Api.injectEndpoints({
  endpoints: (builder) => ({
    getPasswordResetTokenStatus: builder.query<
      PasswordResetTokenStatus,
      string
    >({
      query: (token) => ({
        method: "GET",
        url: "/api/session/password_reset_token_valid",
        body: { token },
      }),
    }),
    forgotPassword: builder.mutation<void, string>({
      query: (email) => ({
        method: "POST",
        url: "/api/session/forgot_password",
        body: { email },
      }),
    }),
    getSessionProperties: builder.query<EnterpriseSettings, void>({
      query: () => ({
        method: "GET",
        url: "/api/session/properties",
      }),
      providesTags: ["session-properties"],
      onQueryStarted: async (_, { queryFulfilled, dispatch }) => {
        const response = await queryFulfilled;
        // In some cases, the response is an HTML string because of a redirect (metabase#62501)
        if (response.data && typeof response.data === "object") {
          dispatch(loadSettings(response.data));
          // compatibility layer for legacy settings on the window object
          MetabaseSettings.setAll(response.data);
        }
      },
    }),
  }),
});

export const {
  useGetPasswordResetTokenStatusQuery,
  useForgotPasswordMutation,
  useGetSessionPropertiesQuery,
} = sessionApi;

// alias for easier use
export const useGetSettingsQuery = useGetSessionPropertiesQuery;
