import cx from "classnames";

import EmbeddingOptionS from "../EmbeddingOption.module.css";
import type { EmbeddingOptionIconProps } from "../types";

export const SdkJsIcon = ({ disabled }: EmbeddingOptionIconProps) => {
  return (
    <svg
      width="40"
      height="32"
      fill="none"
      viewBox="0 0 40 32"
      xmlns="http://www.w3.org/2000/svg"
      className={cx(EmbeddingOptionS.EmbeddingOptionIcon, {
        [EmbeddingOptionS.Disabled]: disabled,
      })}
      data-testid="sdk-js-icon"
      data-disabled={disabled}
    >
      <rect
        x="1"
        y="1"
        width="38"
        height="30"
        rx="3"
        stroke="var(--mb-color-embedding-option-secondary)"
        strokeWidth="2"
      />
      <path
        d="M11.9598 22.126C11.6238 22.138 11.3598 22.048 11.1678 21.856C10.9758 21.664 10.8798 21.418 10.8798 21.118C10.8798 20.89 10.9518 20.692 11.0958 20.524C11.2278 20.344 11.4258 20.248 11.6898 20.236L12.2298 20.2C12.7578 20.164 13.1538 20.002 13.4178 19.714C13.6938 19.414 13.8318 18.988 13.8318 18.436V10.336C13.8318 9.952 13.9278 9.664 14.1198 9.472C14.3238 9.268 14.6118 9.166 14.9838 9.166C15.3558 9.166 15.6378 9.268 15.8298 9.472C16.0338 9.664 16.1358 9.952 16.1358 10.336V18.418C16.1358 19.174 15.9978 19.816 15.7218 20.344C15.4578 20.872 15.0618 21.286 14.5338 21.586C14.0058 21.874 13.3518 22.042 12.5718 22.09L11.9598 22.126ZM23.2727 22.18C22.7447 22.18 22.2167 22.138 21.6887 22.054C21.1607 21.982 20.6627 21.868 20.1947 21.712C19.7267 21.544 19.3067 21.34 18.9347 21.1C18.7187 20.956 18.5687 20.782 18.4847 20.578C18.4007 20.374 18.3707 20.176 18.3947 19.984C18.4307 19.78 18.5087 19.606 18.6287 19.462C18.7607 19.306 18.9227 19.21 19.1147 19.174C19.3067 19.138 19.5167 19.192 19.7447 19.336C20.2727 19.648 20.8307 19.876 21.4187 20.02C22.0067 20.164 22.6247 20.236 23.2727 20.236C24.2207 20.236 24.9107 20.08 25.3427 19.768C25.7747 19.444 25.9907 19.03 25.9907 18.526C25.9907 18.106 25.8347 17.776 25.5227 17.536C25.2227 17.296 24.7007 17.098 23.9567 16.942L21.9767 16.528C20.8367 16.288 19.9847 15.886 19.4207 15.322C18.8687 14.746 18.5927 13.99 18.5927 13.054C18.5927 12.466 18.7127 11.932 18.9527 11.452C19.1927 10.972 19.5287 10.558 19.9607 10.21C20.4047 9.862 20.9267 9.598 21.5267 9.418C22.1387 9.226 22.8107 9.13 23.5427 9.13C24.2627 9.13 24.9467 9.22 25.5947 9.4C26.2427 9.58 26.8247 9.844 27.3407 10.192C27.5327 10.324 27.6587 10.486 27.7187 10.678C27.7907 10.87 27.8087 11.062 27.7727 11.254C27.7367 11.434 27.6527 11.59 27.5207 11.722C27.3887 11.854 27.2207 11.932 27.0167 11.956C26.8247 11.98 26.6027 11.92 26.3507 11.776C25.9067 11.524 25.4567 11.344 25.0007 11.236C24.5447 11.128 24.0527 11.074 23.5247 11.074C22.9727 11.074 22.4987 11.152 22.1027 11.308C21.7067 11.464 21.4007 11.686 21.1847 11.974C20.9807 12.25 20.8787 12.58 20.8787 12.964C20.8787 13.396 21.0227 13.744 21.3107 14.008C21.5987 14.26 22.0907 14.458 22.7867 14.602L24.7487 15.016C25.9367 15.268 26.8187 15.664 27.3947 16.204C27.9827 16.744 28.2767 17.464 28.2767 18.364C28.2767 18.94 28.1567 19.462 27.9167 19.93C27.6887 20.398 27.3527 20.8 26.9087 21.136C26.4767 21.472 25.9547 21.73 25.3427 21.91C24.7307 22.09 24.0407 22.18 23.2727 22.18Z"
        fill="var(--mb-color-embedding-option-primary)"
      />
    </svg>
  );
};
