import dayjs from "dayjs";

import type {
  Engine,
  EngineField,
  EngineSource,
  EnterpriseSettingKey,
  EnterpriseSettings,
  FontFile,
  SettingDefinition,
  Settings,
  TokenFeatures,
  TokenStatus,
  Version,
  VersionInfo,
  VersionInfoRecord,
} from "metabase-types/api";
export const createMockEngine = (opts?: Partial<Engine>): Engine => ({
  "driver-name": "PostgreSQL",
  "details-fields": [],
  source: createMockEngineSource(),
  "superseded-by": null,
  "extra-info": null,
  ...opts,
});

export const createMockEngineField = (
  opts?: Partial<EngineField>,
): EngineField => ({
  name: "field",
  "display-name": "Field",
  ...opts,
});

export const createMockEngineSource = (
  opts?: Partial<EngineSource>,
): EngineSource => ({
  type: "official",
  contact: null,
  ...opts,
});

export const createMockEngines = (
  opts?: Record<string, Engine>,
): Record<string, Engine> => ({
  postgres: createMockEngine(),
  communityEngine: createMockEngine({
    "driver-name": "CommunityEngine",
    source: createMockEngineSource({
      type: "community",
    }),
  }),
  ...opts,
});

export const createMockFontFile = (opts?: Partial<FontFile>): FontFile => ({
  src: "https://metabase.test/regular.woff2",
  fontWeight: 400,
  fontFormat: "woff2",
  ...opts,
});

export const createMockVersion = (opts?: Partial<Version>): Version => ({
  tag: "v1",
  ...opts,
});

export const createMockVersionInfoRecord = (
  opts?: Partial<VersionInfoRecord>,
): VersionInfoRecord => ({
  version: "v1",
  released: "2021-01-01",
  patch: true,
  highlights: ["Bug fix"],
  ...opts,
});

export const createMockVersionInfo = (
  opts?: Partial<VersionInfo>,
): VersionInfo => ({
  latest: createMockVersionInfoRecord(),
  older: [createMockVersionInfoRecord()],
  ...opts,
});

export const createMockTokenStatus = (
  opts?: Partial<TokenStatus>,
): TokenStatus => ({
  status: "Token is Valid.",
  valid: true,
  trial: false,
  "valid-thru": "2022-12-30T23:00:00Z",
  features: [],
  ...opts,
});

export const createMockTokenFeatures = (
  opts?: Partial<TokenFeatures>,
): TokenFeatures => ({
  attached_dwh: false,
  advanced_permissions: false,
  audit_app: false,
  cache_granular_controls: false,
  disable_password_login: false,
  cloud_custom_smtp: false,
  content_translation: false,
  content_verification: false,
  embedding: false,
  embedding_sdk: false,
  embedding_simple: false,
  etl_connections: false,
  etl_connections_pg: false,
  hosting: false,
  official_collections: false,
  sandboxes: false,
  scim: false,
  sso_google: false,
  sso_jwt: false,
  sso_ldap: false,
  sso_saml: false,
  session_timeout_config: false,
  whitelabel: false,
  dashboard_subscription_filters: false,
  snippet_collections: false,
  email_allow_list: false,
  email_restrict_recipients: false,
  collection_cleanup: false,
  upload_management: false,
  serialization: false,
  cache_preemptive: false,
  metabot_v3: false,
  ai_entity_analysis: false,
  ai_sql_fixer: false,
  ai_sql_generation: false,
  offer_metabase_ai: false,
  database_routing: false,
  development_mode: false,
  table_data_editing: false,
  documents: false,
  semantic_search: false,
  transforms: false,
  ...opts,
});

export const createMockSettingDefinition = <
  Key extends EnterpriseSettingKey = EnterpriseSettingKey,
>(
  opts: SettingDefinition<Key>,
): SettingDefinition<Key> => ({
  env_name: "",
  is_env_setting: false,
  value: opts.value,
  ...opts,
});

export const createMockSettings = (
  opts?: Partial<Settings | EnterpriseSettings>,
): EnterpriseSettings => ({
  "analytics-uuid": "eefb3320-1d3f-4686-a22a-1d30ae729525",
  "admin-email": "admin@metabase.test",
  "airgap-enabled": false,
  "allowed-iframe-hosts": "*",
  "anon-tracking-enabled": false,
  "application-colors": {},
  "application-font": "Lato",
  "application-font-files": [],
  // eslint-disable-next-line no-literal-metabase-strings -- This is a mock
  "application-name": "Metabase",
  "application-favicon-url": "",
  "available-fonts": [],
  "available-locales": [
    // this is a subset of the locales we have in the real app
    ["de", "German"],
    ["en", "English"],
    ["es", "Spanish"],
    ["ko", "Korean"],
    ["pt_BR", "Portuguese (Brazil)"],
    ["zh_CN", "Chinese (China)"],
    ["zh_HK", "Chinese (Hong Kong SAR China)"],
    ["zh_TW", "Chinese (Taiwan)"],
  ],
  "available-timezones": [
    // this is a subset of the timezones we have in the real app
    "Europe/Paris",
    "Pacific/Auckland",
    "US/Mountain",
    "UTC",
  ],
  "bug-reporting-enabled": false,
  "bcc-enabled?": true,
  "smtp-override-enabled": false,
  "email-from-address-override": null,
  "email-smtp-host-override": "localhost",
  "email-smtp-port-override": 465,
  "email-smtp-security-override": "ssl",
  "email-smtp-username-override": null,
  "email-smtp-password-override": null,
  "cloud-gateway-ips": null,
  "custom-geojson": {
    us_states: {
      name: "United States",
      url: "app/assets/geojson/us-states.json",
      region_key: "STATE",
      region_name: "NAME",
      builtin: true,
    },
    world_countries: {
      name: "World",
      url: "app/assets/geojson/world.json",
      region_key: "ISO_A2",
      region_name: "NAME",
      builtin: true,
    },
  },
  "custom-geojson-enabled": true,
  "custom-formatting": {},
  "custom-homepage": false,
  "custom-homepage-dashboard": null,
  "help-link": "metabase",
  "help-link-custom-destination": "",
  "deprecation-notice-version": undefined,
  "development-mode?": false,
  "disable-cors-on-localhost": false,
  "ee-ai-features-enabled": false,
  "ee-openai-model": "",
  "ee-openai-api-key": "",
  "email-configured?": false,
  "email-smtp-host": null,
  "email-smtp-port": null,
  "email-smtp-security": "none",
  "email-smtp-username": null,
  "email-smtp-password": null,
  "email-from-name": null,
  "email-from-address": null,
  "email-reply-to": null,
  "embedding-app-origin": "",
  "embedding-app-origins-sdk": "",
  "embedding-app-origins-interactive": "",
  "enable-embedding": false,
  "non-table-chart-generated": true,
  "enable-embedding-static": false,
  "enable-embedding-sdk": false,
  "enable-embedding-simple": false,
  "enable-embedding-interactive": false,
  "enable-nested-queries": true,
  "enable-pivoted-exports": true,
  "enable-sandboxes?": true,
  "expand-browse-in-nav": true,
  "expand-bookmarks-in-nav": true,
  "query-caching-ttl-ratio": 10,
  "query-caching-min-ttl": 60,
  "enable-password-login": true,
  "enable-public-sharing": false,
  "enable-xrays": false,
  engines: createMockEngines(),
  "example-dashboard-id": 1,
  gsheets: {},
  "humanization-strategy": "simple",
  /**
   * This is a derived setting and it reads either from an env, or from the list
   * of databases. It checks whether there is a db with `is_sample` property.
   * You probably don't want to set this directly in tests because it can get out
   * of sync with the database state (whch should be a source of truth).
   */
  "has-sample-database?": undefined,
  "has-user-setup": true,
  "hide-embed-branding?": true,
  "instance-creation": dayjs().toISOString(),
  "show-static-embed-terms": true,
  "show-sdk-embed-terms": true,
  "show-simple-embed-terms": true,
  "google-auth-auto-create-accounts-domain": null,
  "google-auth-client-id": null,
  "google-auth-configured": false,
  "google-auth-enabled": false,
  "is-hosted?": false,
  "jwt-enabled": false,
  "jwt-configured": false,
  "jwt-user-provisioning-enabled?": false,
  "jwt-identity-provider-uri": null,
  "jwt-shared-secret": null,
  "jwt-attribute-email": null,
  "jwt-attribute-firstname": null,
  "jwt-attribute-lastname": null,
  "jwt-attribute-groups": null,
  "jwt-group-sync": false,
  "ldap-configured?": false,
  "ldap-enabled": false,
  "ldap-port": 389, // default value from API
  "ldap-host": null,
  "ldap-security": null,
  "ldap-bind-dn": null,
  "ldap-password": null,
  "ldap-user-base": null,
  "ldap-user-filter": null,
  "ldap-user-provisioning-enabled?": false,
  "ldap-attribute-email": null,
  "ldap-attribute-firstname": null,
  "ldap-attribute-lastname": null,
  "ldap-group-sync": false,
  "ldap-group-base": null,
  "ldap-group-mappings": null,
  "ldap-group-membership-filter": "(member={dn})",
  "loading-message": "doing-science",
  "map-tile-server-url": "https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",
  "native-query-autocomplete-match-style": "substring",
  "openai-api-key": null,
  "openai-organization": null,
  "openai-model": null,
  "openai-available-models": [],
  "other-sso-enabled?": false,
  "password-complexity": { total: 6, digit: 1 },
  "persisted-models-enabled": false,
  "persisted-model-refresh-cron-schedule": "0 0 0/6 * * ? *",
  "database-replication-enabled": null,
  "database-replication-connections": null,
  "premium-embedding-token": null,
  "read-only-mode": false,
  "redirect-all-requests-to-https": false,
  "report-timezone": "Europe/London",
  "report-timezone-short": "UTC",
  "report-timezone-long": "Europe/London",
  "saml-configured": false,
  "saml-enabled": false,
  "saml-identity-provider-uri": null,
  "saml-application-name": null,
  "saml-user-provisioning-enabled?": false,
  "saml-attribute-email": null,
  "saml-attribute-firstname": null,
  "saml-attribute-lastname": null,
  "saml-identity-provider-issuer": null,
  "saml-identity-provider-certificate": null,
  "saml-keystore-password": null,
  "saml-keystore-alias": null,
  "saml-keystore-path": null,
  "saml-attribute-group": null,
  "saml-group-sync": null,
  "saml-group-mappings": null,
  "scim-enabled": false,
  "scim-base-url": "http://localhost:3000/api/ee/scim/v2/",
  "snowplow-url": "",
  "search-engine": "appdb",
  "search-typeahead-enabled": true,
  "setup-token": null,
  "session-cookies": null,
  "session-cookie-samesite": "lax",
  "session-timeout": null,
  "slack-bug-report-channel": null,
  "snowplow-enabled": false,
  "show-database-syncing-modal": false,
  "show-google-sheets-integration": false,
  "show-homepage-data": false,
  "show-homepage-pin-message": false,
  "show-homepage-xrays": false,
  "show-metabase-links": true,
  "show-metabot": true,
  "show-updated-permission-modal": false,
  "show-updated-permission-banner": false,
  "site-locale": "en",
  "site-name": "Metabae",
  "site-url": "http://localhost:3000",
  "site-uuid": "1234",
  "slack-app-token": null,
  "slack-token": null,
  "slack-token-valid?": false,
  "start-of-week": "sunday",
  "store-url": "https://store.staging.metabase.com",
  "subscription-allowed-domains": null,
  "token-features": createMockTokenFeatures(),
  "token-status": null,
  version: createMockVersion(),
  "version-info": createMockVersionInfo(),
  "version-info-last-checked": null,
  "uploads-settings": {
    db_id: null,
    schema_name: null,
    table_prefix: null,
  },
  "user-visibility": null,
  "last-acknowledged-version": "v1",
  "last-used-native-database-id": 1,
  "embedding-homepage": "hidden",
  "setup-license-active-at-setup": false,
  "notebook-native-preview-shown": false,
  "notebook-native-preview-sidebar-width": null,
  "query-analysis-enabled": false,
  "check-for-updates": true,
  "trial-banner-dismissal-timestamp": null,
  "license-token-missing-banner-dismissal-timestamp": [],
  "sdk-iframe-embed-setup-settings": null,
  ...opts,
});
