import type { SdkStoreState } from "embedding-sdk-bundle/store/types";
import { getSetting } from "metabase/selectors/settings";
import type { State } from "metabase-types/store";

export const getLoginStatus = (state: SdkStoreState) => state.sdk?.loginStatus;

export const getIsInitialized = (state: SdkStoreState) =>
  getLoginStatus(state).status !== "uninitialized";

export const getIsLoggedIn = (state: SdkStoreState) =>
  getLoginStatus(state).status === "success";

export const getSessionTokenState = (state: SdkStoreState) => state.sdk.token;

export const getPlugins = (state: SdkStoreState) => state.sdk.plugins;

export const getEventHandlers = (state: SdkStoreState | State) =>
  "sdk" in state ? state.sdk.eventHandlers : null;

export const getUsageProblem = (state: SdkStoreState) => state.sdk.usageProblem;

export const getLoaderComponent = (state: SdkStoreState) =>
  state.sdk.loaderComponent;

export const getErrorComponent = (state: SdkStoreState) =>
  state.sdk.errorComponent;

export const getMetabaseInstanceUrl = (state: SdkStoreState) =>
  state.sdk?.metabaseInstanceUrl;

export const getMetabaseInstanceVersion = (state: SdkStoreState) =>
  state.sdk?.metabaseInstanceVersion ?? getSetting(state, "version")?.tag;

export const getFetchRefreshTokenFn = (state: SdkStoreState) =>
  state.sdk.fetchRefreshTokenFn;

export const getAvailableFonts = (state: SdkStoreState) =>
  getSetting(state, "available-fonts");
