const { H } = cy;

describe("scenarios > about Metabase", () => {
  beforeEach(() => {
    H.restore();
    cy.signInAsAdmin();

    cy.visit("/");
    cy.icon("gear").click();
    // eslint-disable-next-line no-unscoped-text-selectors -- deprecated usage
    cy.findByText("About Metabase").click();
  });

  it(
    "should display correct Metabase version (metabase#15656)",
    { tags: "@skip" },
    () => {
      // eslint-disable-next-line no-unscoped-text-selectors -- deprecated usage
      cy.findByText(/You're on version v[01](\.\d+){2,3}(-[\w\d]+)?/i);
      // eslint-disable-next-line no-unscoped-text-selectors -- deprecated usage
      cy.findByText(/Built on \d{4}-\d{2}-\d{2}/);

      // eslint-disable-next-line no-unscoped-text-selectors -- deprecated usage
      cy.findByText("Branch: ?").should("not.exist");
      // eslint-disable-next-line no-unscoped-text-selectors -- deprecated usage
      cy.findByText("Hash: ?").should("not.exist");
    },
  );
});
