---
title: How to find a known bug or limitation
---

# How to find a known bug or limitation

If you can't find or solve your problem using the [troubleshooting guides](./index.md), you may be running into an issue that we're still working on.

## How to find a known bug

If your work in Metabase is crashing, missing, or not being saved, you might have found a bug.

1. Go to the [Metabase GitHub issues page](https://github.com/metabase/metabase/issues).

2. Click on the **Label** dropdown and select `Type: Bug`.

   > If you're encountering problems after your Metabase version was recently upgraded, you can add the label `.Regression`.

3. Choose least one value in the **Label** dropdown that matches the feature you're having trouble with.

   > Add additional keywords to the search bar above the list of results. Hit Enter/Return to run the search.

   > Click **Sort** and select the thumbs up emoji (👍) to view the most commonly encountered bugs.

4. If you find an existing bug that matches your problem, add a thumbs up emoji to help the team prioritize it.

5. If you can't find your problem, and you're sure that it's not a [product limitation](#how-to-find-a-known-product-limitation), you can [create a new bug report](./bugs.md).

## How to find a known product limitation

If the functionality you're looking for simply doesn't exist (i.e., it hasn't suddenly gone missing), you might be running into a product limitation.

1. Go to the [Metabase GitHub issues page](https://github.com/metabase/metabase/issues).

2. Click on the **Label** dropdown and select `Type: New Feature`.

3. Choose at least one value in the **Label** dropdown that matches the feature you're looking for.

   > Add additional keywords to the search bar above the list of results. Hit Enter/Return to run the search.

   > Click **Sort** and select the thumbs up emoji (👍) to view the most highly requested features.

4. If you find a feature request that matches what you want to do, add a thumbs up emoji to help the team prioritize it.

5. If a feature request doesn't exist, and your issue isn't [caused by a known bug](#how-to-find-a-known-bug), you can [submit a new feature request](./requesting-new-features.md).
