---
title: Diagnostic information for troubleshooting
---

# Diagnostic information for troubleshooting

To download diagnostic information, hit `Cmd + F1` on Macs, `Ctrl + F1` on PCs. Hit Cmd/Ctrl + K to bring up the command palette, search for "Diagnostic", and select "Open diagnostic error modal"

Select the info you want to include in the diagnostic JSON file. Options include:

- Item definition (like information about a dashboard)
- Browser error messages
- All server error messages
- All server logs
- Server logs from the current user only
- Metabase instance version information

What data Metabase captures depends on the page you're on when you request diagnostic information.

> Review the downloaded file before sharing it, as the diagnostic info may contain sensitive data.

## Metabase server and console logs

Metabase will log errors, both on the server and in the browser console, depending on where the error occurs, which can help you track down an issue. Administrators will have access to the server logs, and everyone with a browser can open the developer tools to see the console logs.

**Accessing the Metabase server logs**: You can look for the logs that Metabase leaves on the server's file system (or wherever else you collect logs). If you're logged into Metabase with an Admin account, you can also access the logs by going to the top right of the screen and clicking on the **gear** icon > **Admin settings** > **Tools** > **Logs**. Check out [How to read the server logs](./server-logs.md)

**Checking for Javascript console errors:** Metabase will send debugging information and errors to your browser's developer console. To open the developer console, follow the instructions for your web browser:

- [Chrome](https://developers.google.com/web/tools/chrome-devtools/open#console)
- [Edge](https://docs.microsoft.com/en-us/microsoft-edge/devtools-guide-chromium)
- [Firefox](https://firefox-source-docs.mozilla.org/devtools-user/)
- [Safari](https://support.apple.com/guide/safari-developer/develop-menu-dev39df999c1/mac)

**Creating a HAR file**: HAR files record network requests generated by your browser. HAR files can be helpful when troubleshooting issues with Metabase performance. Check out [Creating HAR files for troubleshooting](./create-har-file.md).
