---
title: Creating a HAR file for troubleshooting
---

# Creating a HAR file for troubleshooting

HAR (short for _HTTP Archive_) files record network requests generated by your browser. HAR files can be helpful when troubleshooting issues with Metabase performance.

> HAR files can contain sensitive information that you submit during the recording, like passwords and API keys. Before sharing the HAR file with anyone, review the file contents in a text editor.

To create the HAR file, follow the instructions for your web browser:

- [Chrome](#create-a-har-file-in-chrome)
- [Edge](#create-a-har-file-in-edge)
- [Firefox](#create-a-har-file-in-firefox)
- [Safari](#create-a-har-file-in-safari)

## Create a HAR file in Chrome

1. Open Chrome **Developer tools**.
   You can right-click anywhere on the page and select "Inspect".

2. In Developer tools, switch to the **Network** tab.
   The network log recording should start automatically.

3. With the Network tab open and recording in progress, repeat the steps to reproduce the issue.

4. Once you're finished reproducing the issue, right-click anywhere in the table of network calls and select **Save all as HAR with content**.

## Create a HAR file in Edge

1. Open Edge **Developer tools**. You can right-click anywhere on the page and select "Inspect".

2. In Developer tools, switch to the **Network** tab (look for the Wi-Fi icon). The network log recording should start automatically.

3. With the Network tab open and recording in progress, repeat the steps to reproduce the issue.

4. Once you're finished reproducing the issue, right-click anywhere in the table and select **Save all as HAR with content**

## Create a HAR file in Firefox

1. Open Firefox **Developer tools**. You can right-click anywhere on the page and select "Inspect".

2. In Developer tools, switch to the **Network** tab.

3. With the Network tab open and recording in progress, repeat the steps to reproduce the issue.

4. Once you're finished reproducing the issue, right-click anywhere in the table of network calls and select **Save All As HAR**.

## Create a HAR file in Safari

1. If you haven't yet, enable the **Develop** menu by going to **Safari > Settings > Advanced**, and select **Show features for web developers**.

2. Open the Safari developer tools by going to **Develop > Show Web Inspector**.

3. In Developer tools, switch to the **Network** tab. The network log recording should start automatically.

4. With the Network tab open and recording in progress, repeat the steps to reproduce the issue.

5. Once you're finished reproducing the issue, click on **Export** in the top right of the Network tab.
