---
title: "Installation and operation overview"
---

# Installation and operation overview

The birth, care, and feeding of your Metabase.

## [Installing Metabase](./installing-metabase.md)

Options for installing Metabase.

## [Migrating to a production database](./migrating-from-h2.md)

If you started using Metabase with the default, H2 application database, here's how to migrate your data to a production-ready database.

## [Configuring the Metabase application database](./configuring-application-database.md)

Use environment variables to set up your application database.

## [Backing up Metabase application data](./backing-up-metabase-application-data.md)

How to back up your Metabase data: questions, dashboards, and other application data.

## [Upgrading Metabase](upgrading-metabase.md)

How to safely upgrade your Metabase.

## [Development instances](./development-instance.md)

Try out your changes before deploying to production.

## [Serialization](./serialization.md)

Export your questions, dashboards, and more as YAML files that you can check into version control.

## [Monitoring your Metabase](./monitoring-metabase.md)

Monitor your Metabase with JMX.

## [Observability with Prometheus](./observability-with-prometheus.md)

Export Metabase metrics for viewing with Prometheus.

## [Supported browsers](./supported-browsers.md)

Rest in peace, Internet Explorer.

## [About the anonymous usage data we collect](./information-collection.md).

We collect anonymous Metabase usage data to improve the product. We don't collect your data.

## [Accessibility](./accessibility.md)

Notes on Metabase's accessibility.

## [Command line commands](./commands.md)

Metabase's CLI.

---

If you’d like more technical resources to set up your data stack with Metabase, connect with a [Metabase Expert](https://www.metabase.com/partners/).
