---
title: Installing Metabase
redirect_from:
  - /docs/latest/operations-guide/installing-metabase
---

# Installing Metabase

Metabase is built and packaged as a Java JAR file and can be run anywhere that Java is available.

## Metabase Cloud (Recommended)

[Metabase Cloud](https://www.metabase.com/cloud/) is the easiest way to run Metabase. All you need to do is [sign up for a free trial](https://store.metabase.com/checkout), and you're off to the races.

## Self-hosting Metabase

For an overview on how to self-host Metabase, check out [how to run Metabase in production](https://www.metabase.com/learn/metabase-basics/administration/administration-and-operation/metabase-in-production).

### Running on Docker (Recommended for self-hosting)

Run Metabase in a [Docker container](./running-metabase-on-docker.md).

### Running the Jar file

If you're self-hosting but don’t use Docker, the JAR is the easiest way to get started, but it might make it more challenging to move to production. See [running the Metabase Jar](./running-the-metabase-jar-file.md).

## Air-gapped Metabase

If you're self-hosting because you need an air-gapped environment, check out the [air-gapped edition of Metabase](https://www.metabase.com/product/air-gapping).

## Professional services from the Metabase team

If you want help with:

- Set up
- Training
- Data stack
- Embedding
- Data modeling

Check out our [professional services](https://www.metabase.com/product/professional-services).

## Upgrading Metabase

See [Upgrading Metabase](upgrading-metabase.md).

## Other installation options

- [Running on Podman](running-metabase-on-podman.md)
- [Building Metabase from source](../developers-guide/start.md)
- [Running on Azure Web Apps](running-metabase-on-azure.md)
- [Running on Debian as a service](running-metabase-on-debian.md)

We currently do not distribute Metabase on AWS Marketplace or Azure Marketplace.

Metabase doesn't have an officially supported helm chart.

## Connect with a Metabase Expert

If you’d like more technical resources to set up your data stack with Metabase, connect with a [Metabase Expert](https://www.metabase.com/partners/).
