---
title: "Developer Guide"
redirect_from:
  - /docs/latest/developers-guide
---

# Developer Guide

This guide contains detailed information on how to work on Metabase codebase.

## Contributing

- [How to contribute back to the Metabase project](../CONTRIBUTING.md)

## Setup and build

- [How to set up a development environment](devenv.md)
- [How to run a development branch of Metabase using Docker](dev-branch-docker.md)
- [How to compile your own copy of Metabase](build.md)

## Working with the code

- [How to work with the frontend code](frontend.md)
- [How to add support in Metabase for other languages](internationalization.md)
- [Working with Clojure](clojure.md)
- [Annotated Clojure source code](https://metabase-dev-docs.github.io/)
- [Automating Common Tasks with MAGE](mage.md)

## Testing

- [How to write and run end-to-end tests](e2e-tests.md)
- [How to use visual tests](visual-tests.md)

## API documentation

- [Autogenerated API docs](../api.html)
- [Working with the Metabase API](https://www.metabase.com/learn/metabase-basics/administration/administration-and-operation/metabase-api)
- [Driver Interface Changelog](driver-changelog.md)
- [MBQL Library Changelog](mbql-library-changelog.md)

## Database drivers

- [Community drivers](./community-drivers.md)
- [Guide to writing a driver](drivers/start.md)

## Metabase documentation

- [Developing Metabase documentation](./docs.md)

## Releases

- [Metabase release versioning](./versioning.md)
