---
title: Database driver basics
---

# Database driver basics

A Metabase driver:

- **Provides Metabase with basic information for the database** such as the database's capabilities, connection properties, and so on.
- **Provides Metabase with information about the schema of the database** -- the tables (or equivalent), the fields in those tables, the foreign key relationships (for databases that support foreign keys).
  - This functionality is used by the Metabase _sync process_ and stored in the application database.
  - The stored information is used in the visual Query Builder and other places to show users what tables/columns/etc. are available
- **Compiles our in-house query language, [MBQL](https://github.com/metabase/metabase/wiki/Query-Language-'98), into native queries.**
  - MBQL queries are generated by the visual query builder.
  - The Metabase **query processor\*** converts MBQL queries to native queries
- **Executes native queries and returns results**.

## Write your driver as a module and package it as a plugin

Metabase drivers are organized into modules and packaged as plugins. Modules are the source code; plugins are the JARs built from that source code.

A Metabase plugin is a JAR file that contains the compiled class files and a Metabase [plugin manifest](plugins.md) that lists details about the driver. In most cases, plugins are lazily loaded, which means that Metabase won't initialize the drivers until it connects to a database that would use the driver.

For Metabase to use your driver, all you need to do is put the driver JAR you built into the `/plugin` directory, which you'll find in the same directory where you run your metabase.jar. Something like this:

```
/Users/cam/metabase/metabase.jar
/Users/cam/metabase/plugins/my-plugin.jar
```

You can change the plugin directory by setting the [environment variable][env-var] `MB_PLUGINS_DIR`.

## Example module directory

Let's take a high-level look at the [SQLite driver](https://github.com/metabase/metabase/tree/master/modules/drivers/sqlite):

```
|-- deps.edn
|-- resources
|   `-- metabase-plugin.yaml
|-- src
|   `-- metabase
|       `-- driver
|           `-- sqlite.clj
`-- test
    `-- metabase
        |-- driver
        |   `-- sqlite_test.clj
        `-- test
            `-- data
                `-- sqlite.clj
```

There are three files to call out here:

### `deps.edn`

The `deps.edn` file specifies the driver's dependencies.

### `resources/metabase-plugin.yaml`

Your driver's [manifest](plugins.md#plugin-manifests) includes details about your driver.

### `src/metabase/driver/sqlite.clj`

This is the core file for your driver. We'll talk more about it in [Implementing multimethods](multimethods.md).

## Next Up

We'll learn more about [plugin manifests](plugins.md).

[env-var]: ../../configuring-metabase/environment-variables.md
