---
title: Databases overview
redirect_from:
  - /docs/latest/databases
---

# Databases overview

## [Adding and managing databases](./connecting.md)

Connect to and manage your databases.

## [Database users, roles, and privileges](./users-roles-privileges.md)

Bundling your privileges into roles based on use cases makes it easier to manage privileges in the future.

## [Syncing and scanning databases](./sync-scan.md)

Metabase runs different types of queries to stay up to date with your database.

## [Encrypting your database connection](./encrypting-details-at-rest.md)

Learn how to encrypt your database connection credentials at rest.

## [SSH tunneling](./ssh-tunnel.md)

Metabase can connect to some databases by first establishing a connection to a server in between Metabase and a data warehouse, then connecting to the data warehouse using that connection as a bridge.

## [SSL certificate](./ssl-certificates.md)

You can connect your Metabase Cloud or self-hosted instance to a database using Secure Socket Layer (SSL) encryption with a certificate.

## [Uploading data](./uploads.md)

You can set Metabase up so you can upload CSV files to a database.
