---
title: "Data modeling overview"
redirect_from:
  - /docs/latest/data-modeling
---

# Data modeling overview

Metabase provides tools for organizing your data and making it easier for people to understand.

## [Models](./models.md)

Models curate data from another table or tables from the same database to anticipate the kinds of questions people will ask of the data. You can think of them as derived tables, or a special kind of saved question meant to be used as the starting point for new questions.

## [Model persistence](./model-persistence.md)

Persist model results for faster loading times.

## [Metrics](./metrics.md)

Create metrics to define the official way to calculate important numbers for your team.

## [Table metadata admin settings](./metadata-editing.md)

Guide people to the right data by adding display names, hiding outdated tables, configuring filter types, and more.

## [Field types](./semantic-types.md)

Field types dictate how Metabase displays its data, as well as the column’s special functionality, if any.

## [Setting default formatting for your data](./formatting.md)

Define formatting and display defaults for numbers, currencies, datetimes, and more.

## [Working with JSON](./json-unfolding.md)

Metabase can unfold JSON columns into their component fields, which you can then filter on using the query builder.

## [Segments](./segments.md)

Admins can define segments to create official filters for your data.
