---
title: "Configuration overview"
redirect_from:
  - /docs/latest/configuring-metabase
---

# Configuration overview

## [Setting up Metabase](./setting-up-metabase.md)

A walkthrough of when you first boot up your Metabase.

## [General settings](./settings.md)

Site name, report timezone, and more settings.

## [Email](./email.md)

Set up email for [Alerts](../questions/alerts.md) and [Dashboard subscriptions](../dashboards/subscriptions.md).

## [Slack](./slack.md)

Set up Slack for Alerts and Dashboard subscriptions.

### [Webhooks](./webhooks.md)

Set up webhooks as notification channels for alerts.

## [Environment variables](./environment-variables.md)

Configure Metabase on launch via environment variables.

## [Configuration file](./config-file.md)

On self-hosted Pro and Enterprise plans, you can configure Metabase via a configuration file.

## [Metabase logs configuration](./log-configuration.md)

Tell Metabase what to log.

## [Timezones](./timezones.md)

Guidance on timezone settings.

## [Languages and localization](./localization.md)

Set language, datetime, and currency settings.

## [Uploads](../databases/uploads.md)

Allow people to upload data to collections.

## [Appearance](./appearance.md)

Customize colors, fonts, and other visual elements.

## [Caching query results](./caching.md)

Cache query results for faster loading times.

## [Custom maps](./custom-maps.md)

Upload custom maps to your Metabase.

## [Customizing the Metabase Jetty webserver](./customizing-jetty-webserver.md)

Set SSL and port settings for the Jetty webserver.
