---
title: "Accounts and billing"
version: latest
has_magic_breadcrumbs: true
show_category_breadcrumb: true
show_title_breadcrumb: true
category: "Cloud"
layout: new-docs
---

# Accounts and billing

Managing billing and accounts in the Metabase Store.

## Try out a free 14-day trial of Pro

If you're on a [Starter](https://www.metabase.com/product/starter) cloud plan, you can try out [all the features of Metabase Pro](https://www.metabase.com/product/pro) for free for 14 days with no commitment.

If you want to stick with Pro, you'll have the chance to upgrade. Otherwise, your plan will automatically switch back to Starter.

1. Log in to your Metabase [Store account](https://store.metabase.com).
2. In the **Instances** section, select your instance.
3. Click on **Try a free 14-day trial of Pro**.

Once selected, the Store will display the status of your trial, along with a trial end date. We'll also send you an email with details about the trial.

If you like the Pro features and want to upgrade, you'll need to upgrade your instance, either by clicking on the **Upgrade to Pro** button, or by managing your plan (see the next section).

## Upgrade to Pro (or downgrade to Starter)

If you'd like to switch plans:

1. Log in to your Metabase [Store account](https://store.metabase.com).
2. In the **Instances** section, select the instance you want to change.
3. Click on **Manage plan**.
4. Select the plan you want.
5. Click **Change plan**.

## Add people to manage your Metabase Store account

You can add people to your account to allow them to manage your Metabase Store account (not your Metabase instance).

1. Log in to your Metabase [Store account](https://store.metabase.com).
2. Go to **Settings**.
3. Scroll to **Managers**.
4. Enter email address of the person(s) you'd like to invite.
5. The Store will send them an email prompting them to create a Metabase Store account.

## Add people to receive billing and/or technical notifications

You can include contacts to receive billing notifications, as well as technical notifications, like info about new Metabase releases.

1. Log in to your Metabase [Store account](https://store.metabase.com).
2. Go to **Settings**.
3. Scroll to **Contacts**.
4. Enter email address of the person(s) you'd like to invite.
5. The Store will send them an email notifying them that they've been added to Metabase's contact list.

## Cancel a subscription or trial

To cancel a Starter or Pro plan directly in the Metabase Store:

1. Log in to your Metabase [Store account](https://store.metabase.com).
2. Go to **Instances**.
3. Under the instance with the subscription that you want to cancel, click **Cancel subscription and delete instance**. If you're on an Enterprise plan, you'll need to [contact support](https://www.metabase.com/help-premium).

## Update payment information

1. Log in to your Metabase [Store account](https://store.metabase.com).
2. Navigate to **Billing**.
3. Click on the payment method that you want to update.
4. Enter new credit card information.
5. Click on **Update**.

If your Metabase was suspended due to a failed payment, the Store will automatically restore your Metabase upon a successful payment.

## Switch to annual billing

1. Log in to your Metabase [Store account](https://store.metabase.com).
2. Go to **Instances**.
3. Navigate to the instance you want to switch to annual billing.
4. Click on **Manage plan** next to the plan name.
5. Confirm the plan selection and toggle on **Switch to annual billing**.
6. Click on **Switch plan**.

Note that you cannot switch back to monthly billing until your annual cycle has completed.

## Download past invoices

1. Log in to your Metabase [Store account](https://store.metabase.com).
2. Go to **Billing**.
3. Scroll down to **Invoices** to view past or open invoices.

## W-9 form requests

See Metabase's updated [W9 form](https://www.metabase.com/files/2024_W9_signed.pdf).

## Update your Tax ID

1. Log in to your Metabase [Store account](https://store.metabase.com).
2. Go to on **Billing**.
3. Click on **Invoice Tax IDs**.
4. Enter your country and Tax ID.
5. Click **Save**.

## Change the company name on invoices/receipts

The primary account holder should request a name change by emailing [billing@metabase.com](mailto:billing@metabase.com).

## Reset your Admin password

If you need to reset your Admin password, [contact support](https://www.metabase.com/help-premium).

## Change your company name

1. Navigate to your Metabase Store.
2. Go to **Settings**.
3. Click **Change company name**.

## Change your billing address

1. Navigate to your Metabase Store.
2. Go to **Billing**.
3. Click on **Billing address**.
4. Update your billing address.
5. Click **Save**.

### Add or change your shipping address

1. Navigate to your Metabase Store.
2. Go to **Billing**.
3. Click on **Shipping address**.
4. Add or update your shipping address.
5. Click **Save**.

## Change the primary account holder

If you need to change your primary account holder, for example if your primary account holder left your company:

- If another person at your company holds a Metabase Store account, work with them to add you to your company's Metabase Store account.
- If there is no other account holder, email [billing@metabase.com](mailto:billing@metabase.com) to request access to your company's Metabase Store account. Please note that if the primary account holder is unavailable, there is a 48-hour waiting period to process changes to Metabase Store accounts.

## Move from Metabase Cloud to self-hosting Metabase

If you're on Metabase Cloud but need to switch to hosting Metabase yourself, [contact us](https://www.metabase.com/help-premium) and we'll give you a backup of your application database that you can use to restore Metabase on your own infrastructure.

## Further reading

- [How billing works](./how-billing-works.md)
