/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat;

import java.io.IOException;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication(scanBasePackages={"org.owasp.webgoat"})
@ServletComponentScan
public class StartWebGoat
extends SpringBootServletInitializer {
    private static final Logger log = LoggerFactory.getLogger(StartWebGoat.class);

    public static void main(String[] args) {
        int dbPort;
        log.info("Starting WebGoat with args: {}", (Object)StringUtils.arrayToCommaDelimitedString((Object[])args));
        System.setProperty("spring.config.name", "application-webgoat");
        String webgoatPort = System.getenv("WEBGOAT_PORT");
        String databasePort = System.getenv("WEBGOAT_HSQLPORT");
        String webGoatHost = null == System.getenv("WEBGOAT_HOST") ? "127.0.0.1" : System.getenv("WEBGOAT_HOST");
        int goatPort = webgoatPort == null ? 8080 : Integer.parseInt(webgoatPort);
        int n = dbPort = databasePort == null ? 9001 : Integer.parseInt(databasePort);
        if (StartWebGoat.isAlreadyRunning((String)webGoatHost, (int)goatPort)) {
            log.error("Port {}:{} is already in use", (Object)webGoatHost, (Object)goatPort);
            System.out.println("Port " + webGoatHost + ":" + goatPort + " is in use. Use environment value WEBGOAT_PORT to set a different value.");
            System.exit(-1);
        }
        if (StartWebGoat.isAlreadyRunning((String)webGoatHost, (int)dbPort)) {
            log.error("Port {}:{} is already in use", (Object)webGoatHost, (Object)goatPort);
            System.out.println("Port " + webGoatHost + ":" + goatPort + " is in use. Use environment value WEBGOAT_HSQLPORT to set a different value.");
            System.exit(-1);
        }
        SpringApplication.run(StartWebGoat.class, (String[])args);
    }

    private static boolean isAlreadyRunning(String host, int port) {
        boolean bl;
        Socket ignored = new Socket(host, port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        ignored.close();
        return bl;
    }
}

