/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat;

import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.hsqldb.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

@Configuration
@ConditionalOnProperty(prefix="webgoat.start", name={"hsqldb"}, havingValue="true")
public class HSQLDBDatabaseConfig {
    private static final Logger log = LoggerFactory.getLogger(HSQLDBDatabaseConfig.class);
    @Value(value="${hsqldb.port:9001}")
    private int hsqldbPort;
    private Server server;

    @Bean(initMethod="start", destroyMethod="stop")
    public Server hsqlStandalone(@Value(value="${webgoat.server.directory}") String directory, @Value(value="${hsqldb.silent:true}") boolean silent, @Value(value="${hsqldb.trace:false}") boolean trace, @Value(value="${server.address}") String address) {
        log.info("Starting internal database on port {} ...", (Object)this.hsqldbPort);
        this.server = new Server();
        this.server.setDatabaseName(0, "webgoat");
        this.server.setDatabasePath(0, directory + "/data/webgoat");
        this.server.setDaemon(true);
        this.server.setAddress(address);
        this.server.setTrace(trace);
        this.server.setSilent(silent);
        this.server.setPort(this.hsqldbPort);
        return this.server;
    }

    @PreDestroy
    public void shutdown() {
        this.server.shutdownCatalogs(1);
    }

    @Bean
    @DependsOn(value={"hsqlStandalone"})
    @Primary
    public DataSource dataSource(@Value(value="${spring.datasource.url}") String url, @Value(value="${spring.datasource.driver-class-name}") String driverClassName) {
        DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource(url);
        driverManagerDataSource.setDriverClassName(driverClassName);
        return driverManagerDataSource;
    }
}

