/*
 * This file is part of dependency-check-core.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright (c) 2022 Jeremy Long. All Rights Reserved.
 */
package org.owasp.dependencycheck.data.update.cisa;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.junit.Test;
import static org.junit.Assert.*;
import org.owasp.dependencycheck.data.knownexploited.json.KnownExploitedVulnerabilitiesSchema;

/**
 *
 * @author jeremy
 */
public class KnownExploitedVulnerabilityParserTest {

    /**
     * Test of parse method, of class KnownExploitedVulnerabilityParser.
     */
    @Test
    public void testParse() throws Exception {
        File file = new File("./src/test/resources/update/cisa/known_exploited_vulnerabilities.json");
        try (InputStream in = new FileInputStream(file)) {
            KnownExploitedVulnerabilityParser instance = new KnownExploitedVulnerabilityParser();
            KnownExploitedVulnerabilitiesSchema result = instance.parse(in);
            assertEquals(834, result.getVulnerabilities().size());
        }
    }
}
