/*
 * This file is part of dependency-check-utils.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright (c) 2020 Jeremy Long. All Rights Reserved.
 */
package org.owasp.dependencycheck.data.golang;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author jeremy
 */
public class GoModJsonParserTest {

    final String issue2891 = "{\n"
            + "	\"Path\": \"cloud.google.com/go\",\n"
            + "	\"Version\": \"v0.26.0\",\n"
            + "	\"Time\": \"2018-08-07T10:25:35Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/cloud.google.com/go/@v/v0.26.0.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"contrib.go.opencensus.io/exporter/prometheus\",\n"
            + "	\"Version\": \"v0.2.0\",\n"
            + "	\"Time\": \"2020-06-03T21:32:39Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/contrib.go.opencensus.io/exporter/prometheus/@v/v0.2.0.mod\",\n"
            + "	\"GoVersion\": \"1.13\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/BurntSushi/toml\",\n"
            + "	\"Version\": \"v0.3.1\",\n"
            + "	\"Time\": \"2018-08-15T10:47:33Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/!burnt!sushi/toml@v0.3.1\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/!burnt!sushi/toml/@v/v0.3.1.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/HdrHistogram/hdrhistogram-go\",\n"
            + "	\"Version\": \"v0.9.0\",\n"
            + "	\"Time\": \"2016-10-10T02:54:55Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/!hdr!histogram/hdrhistogram-go@v0.9.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/!hdr!histogram/hdrhistogram-go/@v/v0.9.0.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/alecthomas/template\",\n"
            + "	\"Version\": \"v0.0.0-20190718012654-fb15b899a751\",\n"
            + "	\"Time\": \"2019-07-18T01:26:54Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/alecthomas/template/@v/v0.0.0-20190718012654-fb15b899a751.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/alecthomas/units\",\n"
            + "	\"Version\": \"v0.0.0-20190717042225-c3de453c63f4\",\n"
            + "	\"Time\": \"2019-07-17T04:22:25Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/alecthomas/units/@v/v0.0.0-20190717042225-c3de453c63f4.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/beorn7/perks\",\n"
            + "	\"Version\": \"v1.0.1\",\n"
            + "	\"Time\": \"2019-07-31T12:00:54Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/beorn7/perks@v1.0.1\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/beorn7/perks/@v/v1.0.1.mod\",\n"
            + "	\"GoVersion\": \"1.11\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/cespare/xxhash/v2\",\n"
            + "	\"Version\": \"v2.1.1\",\n"
            + "	\"Time\": \"2019-11-14T17:47:13Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/cespare/xxhash/v2@v2.1.1\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/cespare/xxhash/v2/@v/v2.1.1.mod\",\n"
            + "	\"GoVersion\": \"1.11\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/client9/misspell\",\n"
            + "	\"Version\": \"v0.3.4\",\n"
            + "	\"Time\": \"2018-03-09T01:55:12Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/client9/misspell/@v/v0.3.4.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/codahale/hdrhistogram\",\n"
            + "	\"Version\": \"v0.0.0-20161010025455-3a0bb77429bd\",\n"
            + "	\"Time\": \"2016-10-10T02:54:55Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/codahale/hdrhistogram@v0.0.0-20161010025455-3a0bb77429bd\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/codahale/hdrhistogram/@v/v0.0.0-20161010025455-3a0bb77429bd.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/confluentinc/confluent-kafka-go\",\n"
            + "	\"Version\": \"v1.4.2\",\n"
            + "	\"Time\": \"2020-05-06T13:55:53Z\",\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/confluentinc/confluent-kafka-go@v1.4.2\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/confluentinc/confluent-kafka-go/@v/v1.4.2.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/davecgh/go-spew\",\n"
            + "	\"Version\": \"v1.1.1\",\n"
            + "	\"Time\": \"2018-02-21T23:26:28Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/davecgh/go-spew@v1.1.1\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/davecgh/go-spew/@v/v1.1.1.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/dgrijalva/jwt-go\",\n"
            + "	\"Version\": \"v3.2.0+incompatible\",\n"
            + "	\"Time\": \"2018-03-08T23:13:08Z\",\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/dgrijalva/jwt-go@v3.2.0+incompatible\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/dgrijalva/jwt-go/@v/v3.2.0+incompatible.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/emicklei/go-restful\",\n"
            + "	\"Version\": \"v2.14.2+incompatible\",\n"
            + "	\"Time\": \"2020-08-31T14:05:57Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/emicklei/go-restful/@v/v2.14.2+incompatible.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/gin-contrib/sse\",\n"
            + "	\"Version\": \"v0.1.0\",\n"
            + "	\"Time\": \"2019-06-02T15:02:53Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/gin-contrib/sse/@v/v0.1.0.mod\",\n"
            + "	\"GoVersion\": \"1.12\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/gin-gonic/gin\",\n"
            + "	\"Version\": \"v1.6.3\",\n"
            + "	\"Time\": \"2020-05-03T14:00:20Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/gin-gonic/gin/@v/v1.6.3.mod\",\n"
            + "	\"GoVersion\": \"1.13\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/go-chi/chi\",\n"
            + "	\"Version\": \"v4.1.2+incompatible\",\n"
            + "	\"Time\": \"2020-06-02T19:02:25Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/go-chi/chi/@v/v4.1.2+incompatible.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/go-kit/kit\",\n"
            + "	\"Version\": \"v0.9.0\",\n"
            + "	\"Time\": \"2019-06-24T11:05:17Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/go-kit/kit/@v/v0.9.0.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/go-logfmt/logfmt\",\n"
            + "	\"Version\": \"v0.4.0\",\n"
            + "	\"Time\": \"2018-11-22T01:56:15Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/go-logfmt/logfmt/@v/v0.4.0.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/go-playground/assert/v2\",\n"
            + "	\"Version\": \"v2.0.1\",\n"
            + "	\"Time\": \"2019-10-18T05:09:52Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/go-playground/assert/v2/@v/v2.0.1.mod\",\n"
            + "	\"GoVersion\": \"1.13\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/go-playground/locales\",\n"
            + "	\"Version\": \"v0.13.0\",\n"
            + "	\"Time\": \"2019-10-18T04:58:51Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/go-playground/locales/@v/v0.13.0.mod\",\n"
            + "	\"GoVersion\": \"1.13\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/go-playground/universal-translator\",\n"
            + "	\"Version\": \"v0.17.0\",\n"
            + "	\"Time\": \"2019-11-11T20:22:24Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/go-playground/universal-translator/@v/v0.17.0.mod\",\n"
            + "	\"GoVersion\": \"1.13\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/go-playground/validator/v10\",\n"
            + "	\"Version\": \"v10.2.0\",\n"
            + "	\"Time\": \"2020-02-09T17:35:38Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/go-playground/validator/v10/@v/v10.2.0.mod\",\n"
            + "	\"GoVersion\": \"1.13\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/go-stack/stack\",\n"
            + "	\"Version\": \"v1.8.0\",\n"
            + "	\"Time\": \"2018-08-26T13:48:48Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/go-stack/stack@v1.8.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/go-stack/stack/@v/v1.8.0.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/gogo/protobuf\",\n"
            + "	\"Version\": \"v1.1.1\",\n"
            + "	\"Time\": \"2018-07-17T14:19:46Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/gogo/protobuf/@v/v1.1.1.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/golang/glog\",\n"
            + "	\"Version\": \"v0.0.0-20160126235308-23def4e6c14b\",\n"
            + "	\"Time\": \"2016-01-26T23:53:08Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/golang/glog@v0.0.0-20160126235308-23def4e6c14b\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/golang/glog/@v/v0.0.0-20160126235308-23def4e6c14b.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/golang/groupcache\",\n"
            + "	\"Version\": \"v0.0.0-20191027212112-611e8accdfc9\",\n"
            + "	\"Time\": \"2019-10-27T21:21:12Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/golang/groupcache/@v/v0.0.0-20191027212112-611e8accdfc9.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/golang/mock\",\n"
            + "	\"Version\": \"v1.1.1\",\n"
            + "	\"Time\": \"2018-04-05T21:54:04Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/golang/mock/@v/v1.1.1.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/golang/protobuf\",\n"
            + "	\"Version\": \"v1.4.2\",\n"
            + "	\"Time\": \"2020-05-14T20:44:37Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/golang/protobuf@v1.4.2\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/golang/protobuf/@v/v1.4.2.mod\",\n"
            + "	\"GoVersion\": \"1.9\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/google/go-cmp\",\n"
            + "	\"Version\": \"v0.4.0\",\n"
            + "	\"Time\": \"2019-12-16T21:18:14Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/google/go-cmp@v0.4.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/google/go-cmp/@v/v0.4.0.mod\",\n"
            + "	\"GoVersion\": \"1.8\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/google/gofuzz\",\n"
            + "	\"Version\": \"v1.0.0\",\n"
            + "	\"Time\": \"2019-04-08T17:44:45Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/google/gofuzz@v1.0.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/google/gofuzz/@v/v1.0.0.mod\",\n"
            + "	\"GoVersion\": \"1.12\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/google/uuid\",\n"
            + "	\"Version\": \"v1.1.2\",\n"
            + "	\"Time\": \"2020-07-02T18:56:42Z\",\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/google/uuid@v1.1.2\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/google/uuid/@v/v1.1.2.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/gorilla/mux\",\n"
            + "	\"Version\": \"v1.8.0\",\n"
            + "	\"Time\": \"2020-07-11T20:05:21Z\",\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/gorilla/mux@v1.8.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/gorilla/mux/@v/v1.8.0.mod\",\n"
            + "	\"GoVersion\": \"1.12\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/hashicorp/golang-lru\",\n"
            + "	\"Version\": \"v0.5.1\",\n"
            + "	\"Time\": \"2019-02-27T22:24:58Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/hashicorp/golang-lru@v0.5.1\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/hashicorp/golang-lru/@v/v0.5.1.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/jessevdk/go-flags\",\n"
            + "	\"Version\": \"v1.4.0\",\n"
            + "	\"Time\": \"2018-03-31T11:19:16Z\",\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/jessevdk/go-flags@v1.4.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/jessevdk/go-flags/@v/v1.4.0.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/json-iterator/go\",\n"
            + "	\"Version\": \"v1.1.10\",\n"
            + "	\"Time\": \"2020-06-08T02:58:30Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/json-iterator/go/@v/v1.1.10.mod\",\n"
            + "	\"GoVersion\": \"1.12\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/julienschmidt/httprouter\",\n"
            + "	\"Version\": \"v1.3.0\",\n"
            + "	\"Time\": \"2019-09-29T23:21:22Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/julienschmidt/httprouter/@v/v1.3.0.mod\",\n"
            + "	\"GoVersion\": \"1.7\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/justinas/alice\",\n"
            + "	\"Version\": \"v1.2.0\",\n"
            + "	\"Time\": \"2019-11-05T13:56:12Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/justinas/alice/@v/v1.2.0.mod\",\n"
            + "	\"GoVersion\": \"1.12\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/konsorten/go-windows-terminal-sequences\",\n"
            + "	\"Version\": \"v1.0.1\",\n"
            + "	\"Time\": \"2018-10-04T22:41:46Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/konsorten/go-windows-terminal-sequences@v1.0.1\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/konsorten/go-windows-terminal-sequences/@v/v1.0.1.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/kr/logfmt\",\n"
            + "	\"Version\": \"v0.0.0-20140226030751-b84e30acd515\",\n"
            + "	\"Time\": \"2014-02-26T03:07:51Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/kr/logfmt/@v/v0.0.0-20140226030751-b84e30acd515.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/kr/pretty\",\n"
            + "	\"Version\": \"v0.1.0\",\n"
            + "	\"Time\": \"2018-05-06T08:33:45Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/kr/pretty@v0.1.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/kr/pretty/@v/v0.1.0.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/kr/pty\",\n"
            + "	\"Version\": \"v1.1.1\",\n"
            + "	\"Time\": \"2018-01-13T18:08:13Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/kr/pty/@v/v1.1.1.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/kr/text\",\n"
            + "	\"Version\": \"v0.1.0\",\n"
            + "	\"Time\": \"2018-05-06T08:24:08Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/kr/text@v0.1.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/kr/text/@v/v0.1.0.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/labstack/echo/v4\",\n"
            + "	\"Version\": \"v4.1.17\",\n"
            + "	\"Time\": \"2020-08-28T03:09:25Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/labstack/echo/v4/@v/v4.1.17.mod\",\n"
            + "	\"GoVersion\": \"1.15\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/labstack/gommon\",\n"
            + "	\"Version\": \"v0.3.0\",\n"
            + "	\"Time\": \"2019-08-17T14:33:23Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/labstack/gommon/@v/v0.3.0.mod\",\n"
            + "	\"GoVersion\": \"1.12\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/leodido/go-urn\",\n"
            + "	\"Version\": \"v1.2.0\",\n"
            + "	\"Time\": \"2019-10-15T22:30:40Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/leodido/go-urn/@v/v1.2.0.mod\",\n"
            + "	\"GoVersion\": \"1.13\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/mattn/go-colorable\",\n"
            + "	\"Version\": \"v0.1.7\",\n"
            + "	\"Time\": \"2020-06-26T12:49:29Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/mattn/go-colorable/@v/v0.1.7.mod\",\n"
            + "	\"GoVersion\": \"1.13\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/mattn/go-isatty\",\n"
            + "	\"Version\": \"v0.0.12\",\n"
            + "	\"Time\": \"2020-01-21T17:27:41Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/mattn/go-isatty/@v/v0.0.12.mod\",\n"
            + "	\"GoVersion\": \"1.12\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/matttproud/golang_protobuf_extensions\",\n"
            + "	\"Version\": \"v1.0.1\",\n"
            + "	\"Time\": \"2016-04-24T11:30:07Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/matttproud/golang_protobuf_extensions@v1.0.1\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/matttproud/golang_protobuf_extensions/@v/v1.0.1.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/modern-go/concurrent\",\n"
            + "	\"Version\": \"v0.0.0-20180306012644-bacd9c7ef1dd\",\n"
            + "	\"Time\": \"2018-03-06T01:26:44Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/modern-go/concurrent@v0.0.0-20180306012644-bacd9c7ef1dd\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/modern-go/concurrent/@v/v0.0.0-20180306012644-bacd9c7ef1dd.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/modern-go/reflect2\",\n"
            + "	\"Version\": \"v1.0.1\",\n"
            + "	\"Time\": \"2018-07-18T01:23:57Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/modern-go/reflect2@v1.0.1\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/modern-go/reflect2/@v/v1.0.1.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/mwitkow/go-conntrack\",\n"
            + "	\"Version\": \"v0.0.0-20161129095857-cc309e4a2223\",\n"
            + "	\"Time\": \"2016-11-29T09:58:57Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/mwitkow/go-conntrack/@v/v0.0.0-20161129095857-cc309e4a2223.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/opentracing-contrib/go-gorilla\",\n"
            + "	\"Version\": \"v0.0.0-20190110000444-ced666783644\",\n"
            + "	\"Time\": \"2019-01-10T00:04:44Z\",\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/opentracing-contrib/go-gorilla@v0.0.0-20190110000444-ced666783644\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/opentracing-contrib/go-gorilla/@v/v0.0.0-20190110000444-ced666783644.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/opentracing-contrib/go-stdlib\",\n"
            + "	\"Version\": \"v0.0.0-20190519235532-cf7a6c988dc9\",\n"
            + "	\"Time\": \"2019-05-19T23:55:32Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/opentracing-contrib/go-stdlib@v0.0.0-20190519235532-cf7a6c988dc9\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/opentracing-contrib/go-stdlib/@v/v0.0.0-20190519235532-cf7a6c988dc9.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/opentracing/opentracing-go\",\n"
            + "	\"Version\": \"v1.2.0\",\n"
            + "	\"Time\": \"2020-07-01T21:27:29Z\",\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/opentracing/opentracing-go@v1.2.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/opentracing/opentracing-go/@v/v1.2.0.mod\",\n"
            + "	\"GoVersion\": \"1.14\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/pkg/errors\",\n"
            + "	\"Version\": \"v0.8.1\",\n"
            + "	\"Time\": \"2019-01-03T06:52:24Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/pkg/errors@v0.8.1\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/pkg/errors/@v/v0.8.1.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/pmezard/go-difflib\",\n"
            + "	\"Version\": \"v1.0.0\",\n"
            + "	\"Time\": \"2016-01-10T10:55:54Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/pmezard/go-difflib@v1.0.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/pmezard/go-difflib/@v/v1.0.0.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/prometheus/client_golang\",\n"
            + "	\"Version\": \"v1.7.1\",\n"
            + "	\"Time\": \"2020-06-23T20:31:09Z\",\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/prometheus/client_golang@v1.7.1\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/prometheus/client_golang/@v/v1.7.1.mod\",\n"
            + "	\"GoVersion\": \"1.11\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/prometheus/client_model\",\n"
            + "	\"Version\": \"v0.2.0\",\n"
            + "	\"Time\": \"2020-01-18T22:30:34Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/prometheus/client_model@v0.2.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/prometheus/client_model/@v/v0.2.0.mod\",\n"
            + "	\"GoVersion\": \"1.9\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/prometheus/common\",\n"
            + "	\"Version\": \"v0.10.0\",\n"
            + "	\"Time\": \"2020-05-13T18:30:36Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/prometheus/common@v0.10.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/prometheus/common/@v/v0.10.0.mod\",\n"
            + "	\"GoVersion\": \"1.11\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/prometheus/procfs\",\n"
            + "	\"Version\": \"v0.1.3\",\n"
            + "	\"Time\": \"2020-06-14T12:15:43Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/prometheus/procfs@v0.1.3\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/prometheus/procfs/@v/v0.1.3.mod\",\n"
            + "	\"GoVersion\": \"1.12\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/prometheus/statsd_exporter\",\n"
            + "	\"Version\": \"v0.15.0\",\n"
            + "	\"Time\": \"2020-03-05T09:36:11Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/prometheus/statsd_exporter/@v/v0.15.0.mod\",\n"
            + "	\"GoVersion\": \"1.13\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/sirupsen/logrus\",\n"
            + "	\"Version\": \"v1.7.0\",\n"
            + "	\"Time\": \"2020-05-28T08:56:38Z\",\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/sirupsen/logrus@v1.7.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/sirupsen/logrus/@v/v1.7.0.mod\",\n"
            + "	\"GoVersion\": \"1.13\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/slok/go-http-metrics\",\n"
            + "	\"Version\": \"v0.9.0\",\n"
            + "	\"Time\": \"2020-10-03T09:10:41Z\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/slok/go-http-metrics/@v/v0.9.0.mod\",\n"
            + "	\"GoVersion\": \"1.15\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/stretchr/objx\",\n"
            + "	\"Version\": \"v0.1.1\",\n"
            + "	\"Time\": \"2018-01-25T22:19:50Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/stretchr/objx@v0.1.1\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/stretchr/objx/@v/v0.1.1.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/stretchr/testify\",\n"
            + "	\"Version\": \"v1.6.1\",\n"
            + "	\"Time\": \"2020-06-05T10:48:45Z\",\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/stretchr/testify@v1.6.1\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/stretchr/testify/@v/v1.6.1.mod\",\n"
            + "	\"GoVersion\": \"1.13\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/uber/jaeger-client-go\",\n"
            + "	\"Version\": \"v2.25.0+incompatible\",\n"
            + "	\"Time\": \"2020-07-13T20:13:03Z\",\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/github.com/uber/jaeger-client-go@v2.25.0+incompatible\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/uber/jaeger-client-go/@v/v2.25.0+incompatible.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/uber/jaeger-lib\",\n"
            + "	\"Version\": \"v2.4.0+incompatible\",\n"
            + "	\"Time\": \"2020-10-01T19:45:33Z\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/uber/jaeger-lib/@v/v2.4.0+incompatible.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/ugorji/go\",\n"
            + "	\"Version\": \"v1.1.7\",\n"
            + "	\"Time\": \"2019-07-02T15:00:54Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/ugorji/go/@v/v1.1.7.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/ugorji/go/codec\",\n"
            + "	\"Version\": \"v1.1.7\",\n"
            + "	\"Time\": \"2019-07-02T15:00:54Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/ugorji/go/codec/@v/v1.1.7.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/urfave/negroni\",\n"
            + "	\"Version\": \"v1.0.0\",\n"
            + "	\"Time\": \"2018-09-02T02:25:56Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/urfave/negroni/@v/v1.0.0.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/valyala/bytebufferpool\",\n"
            + "	\"Version\": \"v1.0.0\",\n"
            + "	\"Time\": \"2016-08-17T18:16:52Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/valyala/bytebufferpool/@v/v1.0.0.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"github.com/valyala/fasttemplate\",\n"
            + "	\"Version\": \"v1.2.1\",\n"
            + "	\"Time\": \"2020-08-13T13:29:39Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/valyala/fasttemplate/@v/v1.2.1.mod\",\n"
            + "	\"GoVersion\": \"1.12\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"go.opencensus.io\",\n"
            + "	\"Version\": \"v0.22.4\",\n"
            + "	\"Time\": \"2020-06-17T03:48:03Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/go.opencensus.io/@v/v0.22.4.mod\",\n"
            + "	\"GoVersion\": \"1.13\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"go.uber.org/atomic\",\n"
            + "	\"Version\": \"v1.5.1\",\n"
            + "	\"Time\": \"2019-11-19T21:33:40Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/go.uber.org/atomic@v1.5.1\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/go.uber.org/atomic/@v/v1.5.1.mod\",\n"
            + "	\"GoVersion\": \"1.13\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"goji.io\",\n"
            + "	\"Version\": \"v2.0.2+incompatible\",\n"
            + "	\"Time\": \"2019-01-26T23:58:29Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/goji.io/@v/v2.0.2+incompatible.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"golang.org/x/crypto\",\n"
            + "	\"Version\": \"v0.0.0-20200820211705-5c72a883971a\",\n"
            + "	\"Time\": \"2020-08-20T21:17:05Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/golang.org/x/crypto/@v/v0.0.0-20200820211705-5c72a883971a.mod\",\n"
            + "	\"GoVersion\": \"1.11\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"golang.org/x/exp\",\n"
            + "	\"Version\": \"v0.0.0-20190121172915-509febef88a4\",\n"
            + "	\"Time\": \"2019-01-21T17:29:15Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/golang.org/x/exp/@v/v0.0.0-20190121172915-509febef88a4.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"golang.org/x/lint\",\n"
            + "	\"Version\": \"v0.0.0-20190930215403-16217165b5de\",\n"
            + "	\"Time\": \"2019-09-30T21:54:03Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/golang.org/x/lint@v0.0.0-20190930215403-16217165b5de\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/golang.org/x/lint/@v/v0.0.0-20190930215403-16217165b5de.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"golang.org/x/net\",\n"
            + "	\"Version\": \"v0.0.0-20200822124328-c89045814202\",\n"
            + "	\"Time\": \"2020-08-22T12:43:28Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/golang.org/x/net/@v/v0.0.0-20200822124328-c89045814202.mod\",\n"
            + "	\"GoVersion\": \"1.11\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"golang.org/x/oauth2\",\n"
            + "	\"Version\": \"v0.0.0-20180821212333-d2e6202438be\",\n"
            + "	\"Time\": \"2018-08-21T21:23:33Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/golang.org/x/oauth2/@v/v0.0.0-20180821212333-d2e6202438be.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"golang.org/x/sync\",\n"
            + "	\"Version\": \"v0.0.0-20190911185100-cd5d95a43a6e\",\n"
            + "	\"Time\": \"2019-09-11T18:51:00Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/golang.org/x/sync/@v/v0.0.0-20190911185100-cd5d95a43a6e.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"golang.org/x/sys\",\n"
            + "	\"Version\": \"v0.0.0-20200826173525-f9321e4c35a6\",\n"
            + "	\"Time\": \"2020-08-26T17:35:25Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/golang.org/x/sys/@v/v0.0.0-20200826173525-f9321e4c35a6.mod\",\n"
            + "	\"GoVersion\": \"1.12\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"golang.org/x/text\",\n"
            + "	\"Version\": \"v0.3.3\",\n"
            + "	\"Time\": \"2020-06-16T18:28:43Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/golang.org/x/text/@v/v0.3.3.mod\",\n"
            + "	\"GoVersion\": \"1.11\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"golang.org/x/tools\",\n"
            + "	\"Version\": \"v0.0.0-20191029041327-9cc4af7d6b2c\",\n"
            + "	\"Time\": \"2019-10-29T04:13:27Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/golang.org/x/tools@v0.0.0-20191029041327-9cc4af7d6b2c\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/golang.org/x/tools/@v/v0.0.0-20191029041327-9cc4af7d6b2c.mod\",\n"
            + "	\"GoVersion\": \"1.11\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"golang.org/x/xerrors\",\n"
            + "	\"Version\": \"v0.0.0-20191204190536-9bdfabe68543\",\n"
            + "	\"Time\": \"2019-12-04T19:05:36Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/golang.org/x/xerrors@v0.0.0-20191204190536-9bdfabe68543\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/golang.org/x/xerrors/@v/v0.0.0-20191204190536-9bdfabe68543.mod\",\n"
            + "	\"GoVersion\": \"1.11\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"google.golang.org/appengine\",\n"
            + "	\"Version\": \"v1.4.0\",\n"
            + "	\"Time\": \"2018-12-17T20:59:03Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/google.golang.org/appengine/@v/v1.4.0.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"google.golang.org/genproto\",\n"
            + "	\"Version\": \"v0.0.0-20190425155659-357c62f0e4bb\",\n"
            + "	\"Time\": \"2019-04-25T15:56:59Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/google.golang.org/genproto/@v/v0.0.0-20190425155659-357c62f0e4bb.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"google.golang.org/grpc\",\n"
            + "	\"Version\": \"v1.20.1\",\n"
            + "	\"Time\": \"2019-04-18T21:20:59Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/google.golang.org/grpc/@v/v1.20.1.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"google.golang.org/protobuf\",\n"
            + "	\"Version\": \"v1.23.0\",\n"
            + "	\"Time\": \"2020-05-14T20:12:30Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/google.golang.org/protobuf@v1.23.0\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/google.golang.org/protobuf/@v/v1.23.0.mod\",\n"
            + "	\"GoVersion\": \"1.9\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"gopkg.in/alecthomas/kingpin.v2\",\n"
            + "	\"Version\": \"v2.2.6\",\n"
            + "	\"Time\": \"2017-12-17T18:08:38Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/gopkg.in/alecthomas/kingpin.v2@v2.2.6\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/gopkg.in/alecthomas/kingpin.v2/@v/v2.2.6.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"gopkg.in/check.v1\",\n"
            + "	\"Version\": \"v1.0.0-20190902080502-41f04d3bba15\",\n"
            + "	\"Time\": \"2019-09-02T08:05:02Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/gopkg.in/check.v1@v1.0.0-20190902080502-41f04d3bba15\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/gopkg.in/check.v1/@v/v1.0.0-20190902080502-41f04d3bba15.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"gopkg.in/yaml.v2\",\n"
            + "	\"Version\": \"v2.2.8\",\n"
            + "	\"Time\": \"2020-01-21T17:19:40Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/gopkg.in/yaml.v2@v2.2.8\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/gopkg.in/yaml.v2/@v/v2.2.8.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"gopkg.in/yaml.v3\",\n"
            + "	\"Version\": \"v3.0.0-20200313102051-9f266ea9e77c\",\n"
            + "	\"Time\": \"2020-03-13T10:20:51Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"Dir\": \"/Users/me/go/pkg/mod/gopkg.in/yaml.v3@v3.0.0-20200313102051-9f266ea9e77c\",\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/gopkg.in/yaml.v3/@v/v3.0.0-20200313102051-9f266ea9e77c.mod\"\n"
            + "}\n"
            + "{\n"
            + "	\"Path\": \"honnef.co/go/tools\",\n"
            + "	\"Version\": \"v0.0.0-20190102054323-c2f93a96b099\",\n"
            + "	\"Time\": \"2019-01-02T05:43:23Z\",\n"
            + "	\"Indirect\": true,\n"
            + "	\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/honnef.co/go/tools/@v/v0.0.0-20190102054323-c2f93a96b099.mod\"\n"
            + "}\n"
            + "{\n"
            + " \"Path\": \"github.com/Microsoft/hcsshim\",\n"
            + " \"Version\": \"v0.8.7\",\n"
            + " \"Replace\": {\n"
            + " \"Path\": \"github.com/Microsoft/hcsshim\",\n"
            + " \"Version\": \"v0.8.8-0.20200421182805-c3e488f0d815\",\n"
            + " \"Time\": \"2020-04-21T18:28:05Z\",\n"
            + " \"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/!microsoft/hcsshim/@v/v0.8.8-0.20200421182805-c3e488f0d815.mod\"\n"
            + "},\n"
            + "	\"Indirect\": true,\n"
            + "\"GoMod\": \"/Users/me/go/pkg/mod/cache/download/github.com/!microsoft/hcsshim/@v/v0.8.8-0.20200421182805-c3e488f0d815.mod\"\n"
            + "}\n";

    /**
     * Test of process method, of class GoModJsonParser.
     */
    @Test
    public void testProcess() throws Exception {
        InputStream inputStream = new ByteArrayInputStream(issue2891.getBytes());
        List<GoModDependency> expResult = null;
        List<GoModDependency> result = GoModJsonParser.process(inputStream);
        assertEquals(96, result.size());
    }
}
