Command Line Arguments
======================

The following table lists the command line arguments:

| Short | Argument Name          | Parameter       | Description                            | Requirement |
|-------|------------------------|-----------------|----------------------------------------|-------------|
|       | \-\-project            | \<name\>        | The name of the project being scanned. | Optional    |
| \-s   | \-\-scan               | \<path\>        | The path to scan \- this option can be specified multiple times. It is also possible to specify Ant style paths (e.g. 'directory/**/*.jar'); if using an Ant style path it is highly recommended that you use single quotes around the path so that the shell itself does not automatically perform replacements (see [issue #1812](https://github.com/jeremylong/DependencyCheck/issues/1812). | Required |
|       | \-\-exclude            | \<pattern\>     | The path patterns to exclude from the scan \- this option can be specified multiple times. This accepts Ant style path patterns (e.g. **/exclude/**). | Optional |
|       | \-\-symLink            | \<depth\>       | The depth that symbolic links will be followed; the default is 0 meaning symbolic links will not be followed. | Optional |
| \-o   | \-\-out                | \<path\>        | The folder to write reports to. This defaults to the current directory. If the format is not set to ALL one could specify a specific file name. | Optional |
| \-f   | \-\-format             | \<format\>      | The output format to write to (HTML, XML, CSV, JSON, JUNIT, SARIF, JENKINS, GITLAB, ALL). Multiple formats can be specified by specifying the parameter multiple times. The default is HTML. | Required |
|       | \-\-junitFailOnCVSS    | \<score\>       | If using the JUNIT report format the junitFailOnCVSS sets the CVSS score threshold that is considered a failure. The default is 0. | Optional |
|       | \-\-prettyPrint        |                 | When specified the JSON and XML report formats will be pretty printed. | Optional |
|       | \-\-failOnCVSS         | \<score\>       | If the score set between 0 and 10 the exit code from dependency-check will indicate if a vulnerability with a CVSS score equal to or higher was identified. | Optional |
| \-l   | \-\-log                | \<file\>        | The file path to write verbose logging information. | Optional |
| \-n   | \-\-noupdate           |                 | Disables the automatic updating of the NVD-CVE, hosted-suppressions and RetireJS data. | Optional |
|       | \-\-suppression        | \<files\>       | The file paths to the suppression XML files; used to suppress [false positives](../general/suppression.html). This can be specified more than once to utilize multiple suppression files. The argument can be a local file path, a URL to a suppression file, or even a reference to a file on the class path (see https://github.com/jeremylong/DependencyCheck/issues/1878#issuecomment-487533799) | Optional |
| \-h   | \-\-help               |                 | Print the help message. | Optional |
|       | \-\-advancedHelp       |                 | Print the advanced help message. | Optional |
| \-v   | \-\-version            |                 | Print the version information. | Optional |
|       | \-\-enableExperimental |                 | Enable the [experimental analyzers](../analyzers/index.html). If not set the analyzers marked as experimental below will not be loaded or used. | Optional |
|       | \-\-enableRetired      |                 | Enable the [retired analyzers](../analyzers/index.html). If not set the analyzers marked as retired below will not be loaded or used. | Optional |

Advanced Options
================
| Short | Argument Name                         | Parameter       | Description                                                                                                                                                                                                                                                                                                                        | Default Value |
|-------|---------------------------------------|-----------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
|       | \-\-nvdApiKey                         | \<apiKey\>      | The API Key to access the NVD API; obtained from https://nvd.nist.gov/developers/request-an-api-key                                                                                                                                                                                                                                | &nbsp;        |
|       | \-\-nvdApiEndpoint                    | \<endpoint\>    | The NVD API endpoint URL; setting this is uncommon.                                                                                                                                                                                                                                                                                | https://services.nvd.nist.gov/rest/json/cves/2.0 |
|       | \-\-nvdMaxRetryCount                  | \<count\>       | The maximum number of retry requests for a single call to the NVD API.                                                                                                                                                                                                                                                             | 10            |
|       | \-\-nvdApiDelay                       | \<milliseconds\>| The number of milliseconds to wait between calls to the NVD API.                                                                                                                                                                                                                                                                   | 3500 with an NVD API Key or 8000 without an API Key |
|       | \-\-nvdApiResultsPerPage              | \<number\>      | The number records for a single page from NVD API (must be <=2000).                                                                                                                                                                                                                                                                | 2000 |
|       | \-\-nvdDatafeed                       | \<url\>         | The URL for the NVD API Data feed that can be generated using https://github.com/jeremylong/Open-Vulnerability-Project/tree/main/vulnz#caching-the-nvd-cve-data - example value `https://internal.server/cache/nvdcve-{0}.json.gz`                                                                                                 | &nbsp; |
|       | \-\-nvdUser                           | \<username\>    | Credentials used for basic authentication for the NVD API Data feed.                                                                                                                                                                                                                                                               | &nbsp;        |
|       | \-\-nvdPassword                       | \<password\>    | Credentials used for basic authentication for the NVD API Data feed.                                                                                                                                                                                                                                                               | &nbsp;        |
|       | \-\-nvdBearerToken                    | \<Token\>       | Credentials used for bearer authentication for the NVD API Data feed.                                                                                                                                                                                                                                                              | &nbsp;        |
|       | \-\-nvdValidForHours                  | \<hours\>       | The number of hours to wait before checking for new updates from the NVD. The default is 4 hours.                                                                                                                                                                                                                                  | 4             |
|       | \-\-hints                             | \<file\>        | The file path to the XML hints file \- used to resolve [false negatives](../general/hints.html)                                                                                                                                                                                                                                    | &nbsp;        |
| \-P   | \-\-propertyfile                      | \<file\>        | Specifies a file that contains properties to use instead of application defaults. The key values used in the properties file are not the same as the arguments listed on this page; use the keys here: https://github.com/jeremylong/DependencyCheck/blob/main/core/src/main/resources/dependencycheck.properties                  | &nbsp; |
|       | \-\-updateonly                        |                 | If set only the update phase of dependency-check will be executed; no scan will be executed and no report will be generated.                                                                                                                                                                                                       | &nbsp;        |
|       | \-\-disableKnownExploited             |                 | Sets whether the Known Exploited Vulnerability update and analyzer are enabled.                                                                                                                                                                                                                                                    | &nbsp;        |
|       | \-\-kevURL                            | \<url\>         | URL to the CISA Known Exploited Vulnerabilities JSON data feed.                                                                                                                                                                                                                                                                    | https://www.cisa.gov/sites/default/files/feeds/known_exploited_vulnerabilities.json |
|       | \-\-kevUser                           | \<user\>        | Credentials used for basic authentication for the CISA Known Exploited Vulnerabilities JSON data feed.                                                                                                                                                                                                                             | &nbsp;        |
|       | \-\-kevPassword                       | \<password\>    | Credentials used for basic authentication for URL to the CISA Known Exploited Vulnerabilities JSON data feed.                                                                                                                                                                                                                      | &nbsp;        |
|       | \-\-kevBearerToken                    | \<token\>       | Credentials used for bearer authentication for URL to the CISA Known Exploited Vulnerabilities JSON data feed.                                                                                                                                                                                                                     | &nbsp;        |
|       | \-\-disableFileName                   |                 | Disables the File Name Analyzer; in generally, this should not be disabled.                                                                                                                                                                                                                                                        | &nbsp;        |
|       | \-\-disablePyDist                     |                 | Sets whether the [experimental](../analyzers/index.html) Python Distribution Analyzer will be used.                                                                                                                                                                                                                                | &nbsp;        |
|       | \-\-disablePyPkg                      |                 | Sets whether the [experimental](../analyzers/index.html) Python Package Analyzer will be used.                                                                                                                                                                                                                                     | &nbsp;        |
|       | \-\-disableMSBuild                    |                 | Sets whether the MS Build Project Analyzer will be used.                                                                                                                                                                                                                                                                           | &nbsp;        |
|       | \-\-disableNodeJS                     |                 | Sets whether the Node.js Package Analyzer will be used.                                                                                                                                                                                                                                                                            | &nbsp;        |
|       | \-\-disableYarnAudit                  |                 | Sets whether the yarn Audit Analyzer will be used. This analyzer requires an internet connection and that yarn is installed.   Use `--nodeAuditSkipDevDependencies` to skip dev dependencies.                                                                                                                                      | &nbsp;        |
|       | \-\-yarn                              | \<path\>        | The path to `yarn`.                                                                                                                                                                                                                                                                                                                | &nbsp;        |
|       | \-\-disablePnpmAudit                  |                 | Sets whether the pnpm Audit Analyzer will be used. This analyzer requires an internet connection and that pnpm is installed.   Use `--nodeAuditSkipDevDependencies` to skip dev dependencies.                                                                                                                                      | &nbsp;        |
|       | \-\-pnpm                              | \<path\>        | The path to `pnpm`.                                                                                                                                                                                                                                                                                                                | &nbsp;        |
|       | \-\-disableNodeAudit                  |                 | Sets whether the Node Audit Analyzer will be used. This analyzer requires an internet connection.                                                                                                                                                                                                                                  | &nbsp;        |
|       | \-\-disableNodeAuditCache             |                 | When the argument is present the Node Audit Analyzer will not cache results. By default the results are cached for 24 hours.                                                                                                                                                                                                       | &nbsp;        |
|       | \-\-nodeAuditSkipDevDependencies      |                 | Configures the Node Audit Analyzer to skip devDependencies.                                                                                                                                                                                                                                                                        | &nbsp;        |
|       | \-\-nodePackageSkipDevDependencies    |                 | Configures the Node Package Analyzer to skip devDependencies.                                                                                                                                                                                                                                                                      | &nbsp;        |
|       | \-\-disableRetireJS                   |                 | Sets whether the RetireJS Analyzer will be used.                                                                                                                                                                                                                                                                                   | &nbsp;        |
|       | \-\-retireJsForceUpdate               |                 | Sets whether the RetireJS Analyzer will update regardless of the `noupdate` argument.                                                                                                                                                                                                                                              | false         |
|       | \-\-retireJsUrl                       | \<url\>         | The URL to the Retire JS repository.                                                                                                                                                                                                                                                                                               | https://raw.githubusercontent.com/Retirejs/retire.js/master/repository/jsrepository.json |
|       | \-\-retirejsFilter                    | \<pattern\>     | The RetireJS Analyzers content filter used to exclude JS files when the content contains the given regular expression; this option can be specified multiple times.                                                                                                                                                                | &nbsp;        |
|       | \-\-retirejsFilterNonVulnerable       |                 | Specifies that the Retire JS Analyzer should filter out non-vulnerable JS files from the report.                                                                                                                                                                                                                                   | &nbsp;        |
|       | \-\-retireJsUrlUser                   | \<username\>    | Credentials used for basic authentication for the RetireJS data.                                                                                                                                                                                                                                                                   | &nbsp;        |
|       | \-\-retirejsUrlPassword               | \<password\>    | Credentials used for basic authentication for the RetireJS data.                                                                                                                                                                                                                                                                   | &nbsp;        |
|       | \-\-retirejsUrlBearerToken            | \<token\>       | Credentials used for bearer authentication for the RetireJS data.                                                                                                                                                                                                                                                                  | &nbsp;        |
|       | \-\-disableRubygems                   |                 | Sets whether the [experimental](../analyzers/index.html) Ruby Gemspec Analyzer will be used.                                                                                                                                                                                                                                       | &nbsp;        |
|       | \-\-disableBundleAudit                |                 | Sets whether the [experimental](../analyzers/index.html) Ruby Bundler Audit Analyzer will be used.                                                                                                                                                                                                                                 | &nbsp;        |
|       | \-\-disableCocoapodsAnalyzer          |                 | Sets whether the [experimental](../analyzers/index.html) Cocoapods Analyzer will be used.                                                                                                                                                                                                                                          | &nbsp;        |
|       | \-\-disableCarthageAnalyzer           |                 | Sets whether the [experimental](../analyzers/index.html) Carthage Analyzer will be used.                                                                                                                                                                                                                                           | &nbsp;        |
|       | \-\-disableSwiftPackageManagerAnalyzer |                 | Sets whether the [experimental](../analyzers/index.html) Swift Package Manager Analyzer will be used.                                                                                                                                                                                                                              | &nbsp;        |
|       | \-\-disableSwiftPackageResolvedAnalyzer|                 | Sets whether the [experimental](../analyzers/index.html) Swift Package Resolved Analyzer will be used.                                                                                                                                                                                                                             | &nbsp;        |
|       | \-\-disableAutoconf                   |                 | Sets whether the [experimental](../analyzers/index.html) Autoconf Analyzer will be used.                                                                                                                                                                                                                                           | &nbsp;        |
|       | \-\-disableOpenSSL                    |                 | Sets whether the OpenSSL Analyzer will be used.                                                                                                                                                                                                                                                                                    | &nbsp;        |
|       | \-\-disableCmake                      |                 | Sets whether the [experimental](../analyzers/index.html) Cmake Analyzer will be disabled.                                                                                                                                                                                                                                          | &nbsp;        |
|       | \-\-disableArchive                    |                 | Sets whether the Archive Analyzer will be disabled.                                                                                                                                                                                                                                                                                | &nbsp;        |
|       | \-\-zipExtensions                     | \<strings\>     | A comma-separated list of additional file extensions to be treated like a ZIP file, the contents will be extracted and analyzed.                                                                                                                                                                                                   | &nbsp;        |
|       | \-\-disableJar                        |                 | Sets whether the Jar Analyzer will be disabled.                                                                                                                                                                                                                                                                                    | &nbsp;        |
|       | \-\-disableComposer                   |                 | Sets whether the [experimental](../analyzers/index.html) PHP Composer Lock File Analyzer will be disabled.                                                                                                                                                                                                                         | &nbsp;        |
|       | \-\-composerSkipDev                   |                 | Sets whether the [experimental](../analyzers/index.html) PHP Composer Lock File Analyzer should skip "packages-dev".                                                                                                                                                                                                               | &nbsp;        |
|       | \-\-disableCpan                       |                 | Sets whether the [experimental](../analyzers/index.html) Perl CPAN File Analyzer will be disabled.                                                                                                                                                                                                                                 | &nbsp;        |
|       | \-\-disableDart                       |                 | Sets whether the [experimental](../analyzers/index.html) Dart Analyzer will be disabled.                                                                                                                                                                                                                                           | &nbsp;        |
|       | \-\-disableOssIndex                   |                 | Sets whether the [OSS Index Analyzer](../analyzers/oss-index-analyzer.html) will be disabled. This analyzer requires an internet connection.                                                                                                                                                                                       | &nbsp;        |
|       | \-\-disableOssIndexCache              |                 | When the argument is present the OSS Index Analyzer will not cache results. By default results are cached for 24 hours.                                                                                                                                                                                                            | &nbsp;        |
|       | \-\-ossIndexUsername                  | \<username\>    | To authenticate Sonatype OSS Index requests and profit from higher rate limits, provide the OSS account email address as username. Provide both a username _and_ a password (see below) or none.                                                                                                                                   | &nbsp;        |
|       | \-\-ossIndexPassword                  | \<password\>    | Password or API token to connect to Sonatype's OSS Index. Provide both a username (see above) _and_ a password or none.                                                                                                                                                                                                            | &nbsp;        |
|       | \-\-ossIndexRemoteErrorWarnOnly       | \<true\|false\> | Whether we should only warn about Sonatype OSS Index remote errors instead of failing completely.                                                                                                                                                                                                                                  | &nbsp;        |
|       | \-\-ossIndexUrl                       | \<url\>         | Alternative URL for the OSS Index. If not set the public Sonatype OSS Index will be used.                                                                                                                                                                                                                                          | https://ossindex.sonatype.org |
|       | \-\-disableCentral                    |                 | Sets whether the Central Analyzer will be used. **Disabling this analyzer is not recommended as it could lead to false negatives (e.g. libraries that have vulnerabilities may not be reported correctly).** If this analyzer is being disabled there is a good chance you also want to disable the Artifactory or Nexus Analyzer. | &nbsp; |
|       | \-\-disableCentralCache               |                 | When the argument is present the Central Analyzer will not cache results locally. By default results are cached locally for 30 days.                                                                                                                                                                                               | &nbsp;        |
|       | \-\-centralUrl                        |                 | Alternative URL for Maven Central Search. If not set the public Sonatype Maven Central will be used.                                                                                                                                                                                                                               | https://search.maven.org/solrsearch/select |
|       | \-\-centralUsername                   | \<username\>    | The username to authenticate with bearer auth to the alternative Maven Central url set by the 'centralUrl' argument. If neither basic nor bearer auth config is set it will use an unauthenticated connection.                                                                                                                     | &nbsp;        |
|       | \-\-centralPassword                   | \<password\>    | The password to authenticate with bearer auth to the alternative Maven Central url set by the 'centralUrl' argument. If neither basic nor bearer auth config is set it will use an unauthenticated connection.                                                                                                                     | &nbsp;        |
|       | \-\-centralBearerToken                | \<token\>       | The token to authenticate with bearer auth to the alternative Maven Central url set by the 'centralUrl' argument. If neither basic nor bearer auth config is set it will use an unauthenticated connection.                                                                                                                        | &nbsp;        |
|       | \-\-enableNexus                       |                 | Sets whether the Nexus Analyzer will be used (requires Nexus v2 or Pro v3). You can configure the Nexus URL to utilize an internally hosted Nexus server.                                                                                                                                                                          | &nbsp;        |
|       | \-\-enableArtifactory                 |                 | Sets whether Artifactory analyzer will be used                                                                                                                                                                                                                                                                                     | &nbsp;        |
|       | \-\-artifactoryUrl                    | \<url\>         | The Artifactory server URL.                                                                                                                                                                                                                                                                                                        | &nbsp;        |
|       | \-\-artifactoryUseProxy               | \<true\|false\> | Whether Artifactory should be accessed through a proxy or not.                                                                                                                                                                                                                                                                     | false         |
|       | \-\-artifactoryParallelAnalysis       | \<true\|false\> | Whether the Artifactory analyzer should be run in parallel or not                                                                                                                                                                                                                                                                  | true          |
|       | \-\-artifactoryUsername               | \<username\>    | The user name (only used with API token) to connect to Artifactory instance                                                                                                                                                                                                                                                        | &nbsp;        |
|       | \-\-artifactoryApiToken               | \<token\>       | The API token to connect to Artifactory instance, only used if the username or the API key are not defined by artifactoryAnalyzerServerId, artifactoryAnalyzerUsername or artifactoryAnalyzerApiToken.                                                                                                                             | &nbsp;        |
|       | \-\-artifactoryBearerToken            | \<token\>       | The bearer token to connect to Artifactory instance                                                                                                                                                                                                                                                                                | &nbsp;        |
|       | \-\-nexus                             | \<url\>         | The url to the Nexus Server's web service end point (example: http://domain.enterprise/nexus/service/local/). If not set the Nexus Analyzer will be disabled.                                                                                                                                                                      | &nbsp;        |
|       | \-\-nexusUser                         | \<username\>    | The username to authenticate to the Nexus Server's REST API Endpoint. If not set the Nexus Analyzer will use an unauthenticated connection.                                                                                                                                                                                        | &nbsp;        |
|       | \-\-nexusPass                         | \<password\>    | The password to authenticate to the Nexus Server's REST API Endpoint. If not set the Nexus Analyzer will use an unauthenticated connection.                                                                                                                                                                                        | &nbsp;        |
|       | \-\-nexusUsesProxy                    | \<true\|false\> | Whether or not the defined proxy should be used when connecting to Nexus.                                                                                                                                                                                                                                                          | true          |
|       | \-\-disableNuspec                     |                 | Sets whether the .NET Nuget Nuspec Analyzer will be used.                                                                                                                                                                                                                                                                          | &nbsp;        |
|       | \-\-disableNugetconf                  |                 | Sets whether the [experimental](../analyzers/index.html) .NET Nuget packages.config Analyzer will be used.                                                                                                                                                                                                                         | &nbsp;        |
|       | \-\-disableAssembly                   |                 | Sets whether the .NET Assembly Analyzer should be used.                                                                                                                                                                                                                                                                            | &nbsp;        |
|       | \-\-dotnet                            | \<path\>        | The path to dotnet core for .NET Assembly analysis on non-windows systems.                                                                                                                                                                                                                                                         | &nbsp;        |
|       | \-\-disableGolangDep                  |                 | Sets whether the [experimental](../analyzers/index.html) Go Dependency Analyzer should be used.                                                                                                                                                                                                                                    | &nbsp;        |
|       | \-\-disableGolangMod                  |                 | Sets whether the [experimental](../analyzers/index.html) Go Mod Analyzer should be used.                                                                                                                                                                                                                                           | &nbsp;        |
|       | \-\-disableMixAudit                   |                 | Sets whether the [experimental](../analyzers/index.html) Elixir mix audit Analyze should be used.                                                                                                                                                                                                                                  | &nbsp;        |
|       | \-\-disablePoetry                     |                 | Sets whether the [experimental](../analyzers/index.html) Poetry Analyzer should be used.                                                                                                                                                                                                                                           | &nbsp;        |
|       | \-\-disableVersionCheck               |                 | Sets whether dependency-check should check if a new version is available.                                                                                                                                                                                                                                                          | &nbsp;        |
|       | \-\-go                                | \<path\>        | The path to `go` executable for the Go Mode Analyzer; only necessary if `go` is not on the path.                                                                                                                                                                                                                                   | &nbsp;        |
|       | \-\-bundleAudit                       |                 | The path to the bundle-audit executable.                                                                                                                                                                                                                                                                                           | &nbsp;        |
|       | \-\-bundleAuditWorkingDirectory       | \<path\>        | The path to working directory that the bundle-audit command should be executed from when doing Gem bundle analysis.                                                                                                                                                                                                                | &nbsp;        |
|       | \-\-proxyserver                       | \<server\>      | The proxy server to use when downloading resources; see the [proxy configuration](../data/proxy.html) page for more information.                                                                                                                                                                                                   | &nbsp;        |
|       | \-\-proxyport                         | \<port\>        | The proxy port to use when downloading resources.                                                                                                                                                                                                                                                                                  | &nbsp;        |
|       | \-\-nonProxyHosts                     | \<list\>        | The proxy exclusion list: hostnames (or patterns) for which proxy should not be used. Use pipe, comma or colon as list separator. Example: `something.com\|*.something.com\|www.somethingelse.*`                                                                                                                                   | &nbsp;        |
| \-c   | \-\-connectiontimeout                 | \<timeout\>     | The connection timeout (in milliseconds) to use when downloading resources.                                                                                                                                                                                                                                                        | 10000         |
|       | \-\-readtimeout                       | \<timeout\>     | The read timeout (in milliseconds) to use when downloading resources.                                                                                                                                                                                                                                                              | 60000         |
|       | \-\-proxypass                         | \<pass\>        | The proxy password to use when downloading resources.                                                                                                                                                                                                                                                                              | &nbsp;        |
|       | \-\-proxyuser                         | \<user\>        | The proxy username to use when downloading resources.                                                                                                                                                                                                                                                                              | &nbsp;        |
|       | \-\-connectionString                  | \<connStr\>     | The connection string to the database. See using a [database server](../data/database.html).                                                                                                                                                                                                                                       | &nbsp;        |
|       | \-\-dbDriverName                      | \<driver\>      | The database driver full classname; note, only needs to be set if the driver is not JDBC4 compliant or the JAR is outside of the class path.                                                                                                                                                                                       | &nbsp;        |
|       | \-\-dbDriverPath                      | \<path\>        | The path to the database driver; note, this does not need to be set unless the JAR is outside of the class path.                                                                                                                                                                                                                   | &nbsp;        |
|       | \-\-dbPassword                        | \<password\>    | The password for connecting to the database.                                                                                                                                                                                                                                                                                       | &nbsp;        |
|       | \-\-dbUser                            | \<user\>        | The username used to connect to the database.                                                                                                                                                                                                                                                                                      | &nbsp;        |
| \-d   | \-\-data                              | \<path\>        | The location of the data directory used to store persistent data.                                                                                                                                                                                                                                                                  | /usr/local/var/dependencycheck if installed through brew (→ [formula](https://github.com/Homebrew/homebrew-core/blob/master/Formula/d/dependency-check.rb#L29)). Otherwise, the data directory is created inside the install directory i.e. as a sibling to the `<install-dir>/bin`, `<install-dir>/lib` directories.       |
|       | \-\-purge                             |                 | Delete the local copy of the NVD. This is used to force a refresh of the data.                                                                                                                                                                                                                                                     | &nbsp;        |
|       | \-\-disableHostedSuppressions         |                 | Whether the usage of the hosted suppressions file will be disabled.                                                                                                                                                                                                                                                                | false         |
|       | \-\-hostedSuppressionsForceUpdate     |                 | Whether the hosted suppressions file will update regardless of the `noupdate` argument.                                                                                                                                                                                                                                            | false         |
|       | \-\-hostedSuppressionsValidForHours   | \<hours\>       | The number of hours to wait before checking for new updates of the hosted suppressions file                                                                                                                                                                                                                                        | 2             |
|       | \-\-hostedSuppressionsUrl             | \<url\>         | The URL to a mirrored copy of the hosted suppressions file for internet-constrained environments                                                                                                                                                                                                                                   | https://jeremylong.github.io/DependencyCheck/suppressions/publishedSuppressions.xml |
|       | \-\-hostedSuppressionsUser            | \<user\>        | The user for basic authentication to a mirrored copy of the hosted suppressions file                                                                                                                                                                                                                                               | &nbsp;        |
|       | \-\-hostedSuppressionsPassword        | \<password\>    | The password for basic authentication to a mirrored copy of the hosted suppressions file                                                                                                                                                                                                                                           | &nbsp;        |
|       | \-\-hostedSuppressionsBearerToken     | \<token\>       | The token for bearer authentication to a mirrored copy of the hosted suppressions file                                                                                                                                                                                                                                             | &nbsp;        |
|       | \-\-suppressionUser                   | \<user\>        | The user for basic authentication to web-hosted suppression XML files (as configured with `--suppression`)                                                                                                                                                                                                                         | &nbsp;        |
|       | \-\-suppressionPassword               | \<password\>    | The password for basic authentication to web-hosted suppression XML files (as configured with `--suppression`)                                                                                                                                                                                                                     | &nbsp;        |
|       | \-\-suppressionBearerToken            | \<token\>       | The token for bearer authentication to web-hosted suppression XML files (as configured with `--suppression`)                                                                                                                                                                                                                       | &nbsp;        |
