# Contributing to OWASP dependency-check

## Reporting Bugs

- Ensure you're running the latest version of dependency-check.
- Ensure the bug has not [already been reported](https://github.com/jeremylong/DependencyCheck/issues).
- If you're unable to find an open issue addressing the problem, please [submit a new issue](https://github.com/jeremylong/DependencyCheck/issues/new/choose).
  - Please fill out the appropriate section of the bug report template provided.
  - Delete any sections not needed in the template.
  
## Reporting Vulnerabilities

- If you believe you have found a vulnerability in dependency-check itself (not that dependency-check found a vulnerability); please email jeremy.long@owasp.org.

## Asking Questions

- Your question may be answered by taking a look at the [documentation](https://jeremylong.github.io/DependencyCheck/).
- Search both the [open and closed issues issues in GitHub](https://github.com/jeremylong/DependencyCheck/issues/)
- If you still have a question ask a [new question](https://github.com/jeremylong/DependencyCheck/issues/new?assignees=&labels=question&template=ask-a-question.md&title=)

## Enhancement Requests

- Suggest changes by [submitting a new issue](https://github.com/jeremylong/DependencyCheck/issues/new?assignees=&labels=enhancement&template=feature_request.md&title=) and begin coding.

## Contributing Code

- If you have written a new feature or have fixed a bug please open a new pull request with the patch.
- Use [conventional commits](https://www.conventionalcommits.org/en/v1.0.0/); even for the PR title.
- Ensure the PR description clearly describes the problem and solution. Include any related issue number(s) if applicable.
- Please ensure the PR passes the automated checks performed
- Please consider adding test cases for any new functionality

## Thank you for your contributions

OWASP dependency-check team