/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serialize;

import com.sun.org.apache.xerces.internal.dom.AttrImpl;
import com.sun.org.apache.xerces.internal.dom.AttributeMap;
import com.sun.org.apache.xerces.internal.dom.CoreDocumentImpl;
import com.sun.org.apache.xerces.internal.dom.DOMErrorImpl;
import com.sun.org.apache.xerces.internal.dom.DOMLocatorImpl;
import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.DOMNormalizer;
import com.sun.org.apache.xerces.internal.dom.DOMStringListImpl;
import com.sun.org.apache.xerces.internal.dom3.DOMConfiguration;
import com.sun.org.apache.xerces.internal.dom3.DOMErrorHandler;
import com.sun.org.apache.xerces.internal.dom3.DOMStringList;
import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XML11Char;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xml.internal.serialize.XML11Serializer;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

public class DOMSerializerImpl
implements LSSerializer,
DOMConfiguration {
    private XMLSerializer serializer;
    private XML11Serializer xml11Serializer;
    private DOMStringList fRecognizedParameters;
    protected short features = 0;
    protected static final short NAMESPACES = 1;
    protected static final short WELLFORMED = 2;
    protected static final short ENTITIES = 4;
    protected static final short CDATA = 8;
    protected static final short SPLITCDATA = 16;
    protected static final short COMMENTS = 32;
    protected static final short DISCARDDEFAULT = 64;
    protected static final short INFOSET = 128;
    protected static final short XMLDECL = 256;
    protected static final short NSDECL = 512;
    protected static final short DOM_ELEMENT_CONTENT_WHITESPACE = 1024;
    private DOMErrorHandler fErrorHandler = null;
    private final DOMErrorImpl fError = new DOMErrorImpl();
    private final DOMLocatorImpl fLocator = new DOMLocatorImpl();
    private static final RuntimeException abort = new RuntimeException();

    public DOMSerializerImpl() {
        this.features = (short)(this.features | 1);
        this.features = (short)(this.features | 4);
        this.features = (short)(this.features | 0x20);
        this.features = (short)(this.features | 8);
        this.features = (short)(this.features | 0x10);
        this.features = (short)(this.features | 2);
        this.features = (short)(this.features | 0x200);
        this.features = (short)(this.features | 0x400);
        this.features = (short)(this.features | 0x40);
        this.features = (short)(this.features | 0x100);
        this.serializer = new XMLSerializer();
        this.initSerializer(this.serializer);
    }

    public DOMConfiguration getDomConfig() {
        return this;
    }

    public DOMStringList getParameterNames() {
        if (this.fRecognizedParameters == null) {
            Vector<String> parameters = new Vector<String>();
            parameters.add("namespaces");
            parameters.add("split-cdata-sections");
            parameters.add("discard-default-content");
            parameters.add("xml-declaration");
            parameters.add("canonical-form");
            parameters.add("validate-if-schema");
            parameters.add("validate");
            parameters.add("check-character-normalization");
            parameters.add("datatype-normalization");
            parameters.add("format-pretty-print");
            parameters.add("normalize-characters");
            parameters.add("well-formed");
            parameters.add("infoset");
            parameters.add("namespace-declarations");
            parameters.add("element-content-whitespace");
            parameters.add("entities");
            parameters.add("cdata-sections");
            parameters.add("comments");
            parameters.add("ignore-unknown-character-denormalizations");
            parameters.add("error-handler");
            this.fRecognizedParameters = new DOMStringListImpl(parameters);
        }
        return this.fRecognizedParameters;
    }

    private void initSerializer(XMLSerializer ser) {
        ser.fNSBinder = new NamespaceSupport();
        ser.fLocalNSBinder = new NamespaceSupport();
        ser.fSymbolTable = new SymbolTable();
    }

    public String getNewLine() {
        return this.serializer._format.getLineSeparator();
    }

    public void setNewLine(String newLine) {
        this.serializer._format.setLineSeparator(newLine);
    }

    private void verify(Node node, boolean verifyNames, boolean xml11Version) {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 1: {
                AttributeMap attributes;
                boolean wellformed;
                if (verifyNames && !(wellformed = (this.features & 1) != 0 ? CoreDocumentImpl.isValidQName(node.getPrefix(), node.getLocalName(), xml11Version) : CoreDocumentImpl.isXMLName(node.getNodeName(), xml11Version)) && !wellformed && this.fErrorHandler != null) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)3, null, "wf-invalid-character-in-node-name");
                }
                AttributeMap attributeMap = attributes = node.hasAttributes() ? (AttributeMap)node.getAttributes() : null;
                if (attributes == null) break;
                int i = 0;
                while (i < attributes.getLength()) {
                    Attr attr = (Attr)attributes.item(i);
                    DOMNormalizer.isAttrValueWF(this.fErrorHandler, this.fError, this.fLocator, attributes, (AttrImpl)attr, attr.getValue(), xml11Version);
                    if (verifyNames && !(wellformed = CoreDocumentImpl.isXMLName(node.getNodeName(), xml11Version))) {
                        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Attr", node.getNodeName()});
                        DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)3, null, "wf-invalid-character-in-node-name");
                    }
                    ++i;
                }
                break;
            }
            case 8: {
                if ((this.features & 0x20) == 0) break;
                DOMNormalizer.isCommentWF(this.fErrorHandler, this.fError, this.fLocator, ((Comment)node).getData(), xml11Version);
                break;
            }
            case 5: {
                if (!verifyNames || (this.features & 4) == 0) break;
                CoreDocumentImpl.isXMLName(node.getNodeName(), xml11Version);
                break;
            }
            case 4: {
                DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), xml11Version);
                break;
            }
            case 3: {
                DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), xml11Version);
                break;
            }
            case 7: {
                boolean wellformed;
                ProcessingInstruction pinode = (ProcessingInstruction)node;
                String target = pinode.getTarget();
                if (verifyNames && !(wellformed = xml11Version ? XML11Char.isXML11ValidName(target) : XMLChar.isValidName(target))) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)3, null, "wf-invalid-character-in-node-name");
                }
                DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, pinode.getData(), xml11Version);
                break;
            }
        }
    }

    public LSSerializerFilter getFilter() {
        return this.serializer.fDOMFilter;
    }

    public void setFilter(LSSerializerFilter filter) {
        this.serializer.fDOMFilter = filter;
    }

    private void copySettings(XMLSerializer src, XMLSerializer dest) {
        dest.fDOMErrorHandler = this.fErrorHandler;
        dest._format.setEncoding(src._format.getEncoding());
        dest._format.setLineSeparator(src._format.getLineSeparator());
        dest.fDOMFilter = src.fDOMFilter;
    }

    public Object getParameter(String name) throws DOMException {
        if (name.equals("comments")) {
            return (this.features & 0x20) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("namespaces")) {
            return (this.features & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("xml-declaration")) {
            return (this.features & 0x100) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("cdata-sections")) {
            return (this.features & 8) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("entities")) {
            return (this.features & 4) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("split-cdata-sections")) {
            return (this.features & 0x10) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("well-formed")) {
            return (this.features & 2) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("element-content-whitespace") || name.equals("ignore-unknown-character-denormalizations") || name.equals("namespace-declarations")) {
            return Boolean.TRUE;
        }
        if (name.equals("discard-default-content")) {
            return (this.features & 0x40) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("infoset")) {
            if ((this.features & 4) == 0 && (this.features & 8) == 0 && (this.features & 1) != 0 && (this.features & 2) != 0 && (this.features & 0x20) != 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("format-pretty-print") || name.equals("normalize-characters") || name.equals("canonical-form") || name.equals("validate-if-schema") || name.equals("check-character-normalization") || name.equals("validate") || name.equals("validate-if-schema") || name.equals("datatype-normalization")) {
            return Boolean.FALSE;
        }
        if (name.equals("error-handler")) {
            return this.fErrorHandler;
        }
        if (name.equals("resource-resolver") || name.equals("schema-location") || name.equals("schema-type")) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
        throw new DOMException(8, msg);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setParameter(String name, Object value) throws DOMException {
        if (value instanceof Boolean) {
            boolean state = (Boolean)value;
            if (name.equals("infoset")) {
                if (!state) return;
                this.features = (short)(this.features & 0xFFFFFFFB);
                this.features = (short)(this.features & 0xFFFFFFF7);
                this.features = (short)(this.features | 1);
                this.features = (short)(this.features | 2);
                this.features = (short)(this.features | 0x20);
                return;
            }
            if (name.equals("xml-declaration")) {
                this.features = (short)(state ? this.features | 0x100 : this.features & 0xFFFFFEFF);
                return;
            }
            if (name.equals("namespaces")) {
                this.features = (short)(state ? this.features | 1 : this.features & 0xFFFFFFFE);
                this.serializer.fNamespaces = state;
                return;
            }
            if (name.equals("split-cdata-sections")) {
                this.features = (short)(state ? this.features | 0x10 : this.features & 0xFFFFFFEF);
                return;
            }
            if (name.equals("discard-default-content")) {
                this.features = (short)(state ? this.features | 0x40 : this.features & 0xFFFFFFBF);
                return;
            }
            if (name.equals("well-formed")) {
                this.features = (short)(state ? this.features | 2 : this.features & 0xFFFFFFFD);
                return;
            }
            if (name.equals("entities")) {
                this.features = (short)(state ? this.features | 4 : this.features & 0xFFFFFFFB);
                return;
            }
            if (name.equals("cdata-sections")) {
                this.features = (short)(state ? this.features | 8 : this.features & 0xFFFFFFF7);
                return;
            }
            if (name.equals("comments")) {
                this.features = (short)(state ? this.features | 0x20 : this.features & 0xFFFFFFDF);
                return;
            }
            if (name.equals("canonical-form") || name.equals("validate-if-schema") || name.equals("validate") || name.equals("check-character-normalization") || name.equals("datatype-normalization") || name.equals("format-pretty-print") || name.equals("normalize-characters")) {
                if (!state) return;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            if (!(name.equals("namespace-declarations") || name.equals("element-content-whitespace") || name.equals("ignore-unknown-character-denormalizations"))) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
                throw new DOMException(9, msg);
            }
            if (state) return;
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equals("error-handler")) {
            if (value != null && !(value instanceof DOMErrorHandler)) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
                throw new DOMException(8, msg);
            }
            this.fErrorHandler = (DOMErrorHandler)value;
            return;
        }
        if (name.equals("resource-resolver") || name.equals("schema-location") || name.equals("schema-type") && value != null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
        throw new DOMException(8, msg);
    }

    public boolean canSetParameter(String name, Object state) {
        if (state instanceof Boolean) {
            boolean value = (Boolean)state;
            if (name.equals("namespaces") || name.equals("split-cdata-sections") || name.equals("discard-default-content") || name.equals("xml-declaration") || name.equals("well-formed") || name.equals("infoset") || name.equals("entities") || name.equals("cdata-sections") || name.equals("comments")) {
                return true;
            }
            if (name.equals("canonical-form") || name.equals("validate-if-schema") || name.equals("validate") || name.equals("check-character-normalization") || name.equals("datatype-normalization") || name.equals("format-pretty-print") || name.equals("normalize-characters")) {
                return !value;
            }
            if (name.equals("namespace-declarations") || name.equals("element-content-whitespace") || name.equals("ignore-unknown-character-denormalizations")) {
                return value;
            }
        } else if (name.equals("error-handler") && state == null || state instanceof DOMErrorHandler) {
            return true;
        }
        return false;
    }

    public String writeToString(Node wnode) throws DOMException, LSException {
        StringWriter destination;
        block14: {
            Document doc = wnode.getNodeType() == 9 ? (Document)wnode : wnode.getOwnerDocument();
            Method getVersion = null;
            XMLSerializer ser = null;
            String ver = null;
            try {
                getVersion = doc.getClass().getMethod("getXmlVersion", new Class[0]);
                if (getVersion != null) {
                    ver = (String)getVersion.invoke((Object)doc, null);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ver != null && ver.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                ser = this.xml11Serializer;
            } else {
                ser = this.serializer;
            }
            destination = new StringWriter();
            try {
                this.prepareForSerialization(ser, wnode);
                ser.setOutputCharStream(destination);
                if (wnode == null) {
                    return null;
                }
                if (wnode.getNodeType() == 9) {
                    ser.serialize((Document)wnode);
                    break block14;
                }
                if (wnode.getNodeType() == 11) {
                    ser.serialize((DocumentFragment)wnode);
                    break block14;
                }
                if (wnode.getNodeType() == 1) {
                    ser.serialize((Element)wnode);
                    break block14;
                }
                return null;
            }
            catch (RuntimeException e) {
                if (e == DOMNormalizer.abort) {
                    return null;
                }
                throw new LSException(82, e.toString());
            }
            catch (IOException ioe) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "STRING_TOO_LONG", new Object[]{ioe.getMessage()});
                throw new DOMException(2, msg);
            }
        }
        return destination.toString();
    }

    public boolean writeToURI(Node node, String URI2) throws LSException {
        block26: {
            Method getEncoding;
            if (node == null) {
                return false;
            }
            Method getXmlVersion = null;
            XMLSerializer ser = null;
            String ver = null;
            String encoding = null;
            Document fDocument = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            try {
                getXmlVersion = fDocument.getClass().getMethod("getXmlVersion", new Class[0]);
                if (getXmlVersion != null) {
                    ver = (String)getXmlVersion.invoke((Object)fDocument, null);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ver != null && ver.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                ser = this.xml11Serializer;
            } else {
                ser = this.serializer;
            }
            try {
                getEncoding = fDocument.getClass().getMethod("getActualEncoding", new Class[0]);
                if (getEncoding != null) {
                    encoding = (String)getEncoding.invoke((Object)fDocument, null);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (encoding == null) {
                try {
                    getEncoding = fDocument.getClass().getMethod("getXmlEncoding", new Class[0]);
                    if (getEncoding != null) {
                        encoding = (String)getEncoding.invoke((Object)fDocument, null);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (encoding == null) {
                    encoding = "UTF-8";
                }
            }
            try {
                this.prepareForSerialization(ser, node);
                ser._format.setEncoding(encoding);
                String expanded = XMLEntityManager.expandSystemId(URI2, null, true);
                URL url = new URL(expanded != null ? expanded : URI2);
                OutputStream out = null;
                String protocol = url.getProtocol();
                String host = url.getHost();
                if (protocol.equals("file") && (host == null || host.length() == 0 || host.equals("localhost"))) {
                    out = new FileOutputStream(new File(url.getPath()));
                } else {
                    URLConnection urlCon = url.openConnection();
                    urlCon.setDoInput(false);
                    urlCon.setDoOutput(true);
                    urlCon.setUseCaches(false);
                    if (urlCon instanceof HttpURLConnection) {
                        HttpURLConnection httpCon = (HttpURLConnection)urlCon;
                        httpCon.setRequestMethod("PUT");
                    }
                    out = urlCon.getOutputStream();
                }
                ser.setOutputByteStream(out);
                if (node.getNodeType() == 9) {
                    ser.serialize((Document)node);
                    break block26;
                }
                if (node.getNodeType() == 11) {
                    ser.serialize((DocumentFragment)node);
                    break block26;
                }
                if (node.getNodeType() == 1) {
                    ser.serialize((Element)node);
                    break block26;
                }
                return false;
            }
            catch (RuntimeException e) {
                if (e == DOMNormalizer.abort) {
                    return false;
                }
                throw new LSException(82, e.toString());
            }
            catch (Exception e) {
                if (ser.fDOMErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = e;
                    error.fMessage = e.getMessage();
                    error.fSeverity = (short)2;
                    ser.fDOMErrorHandler.handleError(error);
                }
                throw new LSException(82, e.toString());
            }
        }
        return true;
    }

    private void prepareForSerialization(XMLSerializer ser, Node node) {
        ser.reset();
        ser.features = this.features;
        ser.fDOMErrorHandler = this.fErrorHandler;
        ser.fNamespaces = (this.features & 1) != 0;
        ser._format.setOmitComments((this.features & 0x20) == 0);
        ser._format.setOmitXMLDeclaration((this.features & 0x100) == 0);
        if ((this.features & 2) != 0) {
            Node root = node;
            boolean verifyNames = true;
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            try {
                Method versionChanged = document.getClass().getMethod("isXMLVersionChanged()", new Class[0]);
                if (versionChanged != null) {
                    verifyNames = (Boolean)versionChanged.invoke((Object)document, null);
                }
            }
            catch (Exception e) {}
            while (node != null) {
                this.verify(node, verifyNames, false);
                Node next = node.getFirstChild();
                while (next == null) {
                    next = node.getNextSibling();
                    if (next != null) continue;
                    if (root == (node = node.getParentNode())) {
                        next = null;
                        break;
                    }
                    next = node.getNextSibling();
                }
                node = next;
            }
        }
    }

    public boolean write(Node node, LSOutput destination) throws LSException {
        block35: {
            if (node == null) {
                return false;
            }
            Method getVersion = null;
            XMLSerializer ser = null;
            String ver = null;
            Document fDocument = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            try {
                getVersion = fDocument.getClass().getMethod("getXmlVersion", new Class[0]);
                if (getVersion != null) {
                    ver = (String)getVersion.invoke((Object)fDocument, null);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ver != null && ver.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                ser = this.xml11Serializer;
            } else {
                ser = this.serializer;
            }
            String encoding = null;
            encoding = destination.getEncoding();
            if (encoding == null) {
                Method getEncoding;
                try {
                    getEncoding = fDocument.getClass().getMethod("getActualEncoding", new Class[0]);
                    if (getEncoding != null) {
                        encoding = (String)getEncoding.invoke((Object)fDocument, null);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (encoding == null) {
                    try {
                        getEncoding = fDocument.getClass().getMethod("getXmlEncoding", new Class[0]);
                        if (getEncoding != null) {
                            encoding = (String)getEncoding.invoke((Object)fDocument, null);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                }
            }
            try {
                this.prepareForSerialization(ser, node);
                ser._format.setEncoding(encoding);
                OutputStream outputStream = destination.getByteStream();
                Writer writer = destination.getCharacterStream();
                String uri = destination.getSystemId();
                if (writer == null) {
                    if (outputStream == null) {
                        if (uri == null) {
                            if (ser.fDOMErrorHandler != null) {
                                DOMErrorImpl error = new DOMErrorImpl();
                                error.fType = "no-output-specified";
                                error.fMessage = "no-output-specified";
                                error.fSeverity = (short)3;
                                ser.fDOMErrorHandler.handleError(error);
                            }
                            throw new LSException(82, DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "no-output-specified", null));
                        }
                        String expanded = XMLEntityManager.expandSystemId(uri, null, true);
                        URL url = new URL(expanded != null ? expanded : uri);
                        OutputStream out = null;
                        String protocol = url.getProtocol();
                        String host = url.getHost();
                        if (protocol.equals("file") && (host == null || host.length() == 0 || host.equals("localhost"))) {
                            out = new FileOutputStream(new File(url.getPath()));
                        } else {
                            URLConnection urlCon = url.openConnection();
                            urlCon.setDoInput(false);
                            urlCon.setDoOutput(true);
                            urlCon.setUseCaches(false);
                            if (urlCon instanceof HttpURLConnection) {
                                HttpURLConnection httpCon = (HttpURLConnection)urlCon;
                                httpCon.setRequestMethod("PUT");
                            }
                            out = urlCon.getOutputStream();
                        }
                        ser.setOutputByteStream(out);
                    } else {
                        ser.setOutputByteStream(outputStream);
                    }
                } else {
                    ser.setOutputCharStream(writer);
                }
                if (node.getNodeType() == 9) {
                    ser.serialize((Document)node);
                    break block35;
                }
                if (node.getNodeType() == 11) {
                    ser.serialize((DocumentFragment)node);
                    break block35;
                }
                if (node.getNodeType() == 1) {
                    ser.serialize((Element)node);
                    break block35;
                }
                return false;
            }
            catch (UnsupportedEncodingException ue) {
                if (ser.fDOMErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = ue;
                    error.fType = "unsupported-encoding";
                    error.fMessage = ue.getMessage();
                    error.fSeverity = (short)3;
                    ser.fDOMErrorHandler.handleError(error);
                }
                throw new LSException(82, DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "unsupported-encoding", null));
            }
            catch (RuntimeException e) {
                if (e == DOMNormalizer.abort) {
                    return false;
                }
                throw new LSException(82, e.toString());
            }
            catch (Exception e) {
                if (ser.fDOMErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = e;
                    error.fMessage = e.getMessage();
                    error.fSeverity = (short)2;
                    ser.fDOMErrorHandler.handleError(error);
                }
                e.printStackTrace();
                throw new LSException(82, e.toString());
            }
        }
        return true;
    }
}

