/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.BuildTreeLocalComponentProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentCache;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentProvider;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.internal.Describables;
import org.gradle.internal.Factory;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveStateFactory;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;

public class DefaultBuildTreeLocalComponentProvider
implements BuildTreeLocalComponentProvider,
HoldsProjectState {
    private final ProjectStateRegistry projectStateRegistry;
    private final LocalComponentGraphResolveStateFactory resolveStateFactory;
    private final LocalComponentCache localComponentCache;
    private final LocalComponentProvider localComponentProvider;
    private final ConcurrentMetadataCache originalComponents;
    private final ConcurrentMetadataCache foreignIdentifiedComponents;

    public DefaultBuildTreeLocalComponentProvider(ProjectStateRegistry projectStateRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory, LocalComponentGraphResolveStateFactory resolveStateFactory, LocalComponentCache localComponentCache, LocalComponentProvider localComponentProvider) {
        this.projectStateRegistry = projectStateRegistry;
        this.resolveStateFactory = resolveStateFactory;
        this.localComponentCache = localComponentCache;
        this.localComponentProvider = localComponentProvider;
        this.originalComponents = new ConcurrentMetadataCache(calculatedValueContainerFactory);
        this.foreignIdentifiedComponents = new ConcurrentMetadataCache(calculatedValueContainerFactory);
    }

    public LocalComponentGraphResolveState getComponent(ProjectComponentIdentifier projectIdentifier, BuildIdentifier currentBuild) {
        boolean isLocalProject = projectIdentifier.getBuild().getBuildPath().equals(currentBuild.getBuildPath());
        if (isLocalProject) {
            return this.getLocalComponent(projectIdentifier, this.projectStateRegistry.stateFor(projectIdentifier));
        }
        return this.getLocalComponentWithForeignId(projectIdentifier);
    }

    private LocalComponentGraphResolveState getLocalComponent(ProjectComponentIdentifier projectIdentifier, ProjectState projectState) {
        return this.originalComponents.computeIfAbsent(projectIdentifier, (Factory<LocalComponentGraphResolveState>)() -> this.localComponentCache.computeIfAbsent(projectState, arg_0 -> ((LocalComponentProvider)this.localComponentProvider).getComponent(arg_0)));
    }

    private LocalComponentGraphResolveState getLocalComponentWithForeignId(ProjectComponentIdentifier projectIdentifier) {
        return this.foreignIdentifiedComponents.computeIfAbsent(projectIdentifier, (Factory<LocalComponentGraphResolveState>)() -> this.copyComponentWithForeignId(projectIdentifier));
    }

    private LocalComponentGraphResolveState copyComponentWithForeignId(ProjectComponentIdentifier projectIdentifier) {
        ProjectState projectState = this.projectStateRegistry.stateFor(projectIdentifier);
        CompositeBuildParticipantBuildState buildState = (CompositeBuildParticipantBuildState)projectState.getOwner();
        if (buildState instanceof IncludedBuildState) {
            buildState.ensureProjectsConfigured();
        }
        LocalComponentMetadata metadata = (LocalComponentMetadata)projectState.fromMutableState(p -> {
            LocalComponentGraphResolveState originalComponent = this.getLocalComponent(projectIdentifier, projectState);
            ProjectComponentIdentifier foreignIdentifier = buildState.idToReferenceProjectFromAnotherBuild(projectIdentifier);
            return originalComponent.copy((ComponentIdentifier)foreignIdentifier, originalArtifact -> {
                File file = originalArtifact.getFile();
                return new CompositeProjectComponentArtifactMetadata(foreignIdentifier, (LocalComponentArtifactMetadata)originalArtifact, file);
            });
        });
        return this.resolveStateFactory.stateFor(metadata);
    }

    public void discardAll() {
        this.originalComponents.clear();
        this.foreignIdentifiedComponents.clear();
    }

    private static class ConcurrentMetadataCache {
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;
        private final Map<ProjectComponentIdentifier, CalculatedValueContainer<LocalComponentGraphResolveState, ?>> cache = new ConcurrentHashMap();

        public ConcurrentMetadataCache(CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        }

        private LocalComponentGraphResolveState computeIfAbsent(ProjectComponentIdentifier projectIdentifier, Factory<LocalComponentGraphResolveState> factory) {
            CalculatedValueContainer valueContainer = this.cache.computeIfAbsent(projectIdentifier, (? super K projectComponentIdentifier) -> this.calculatedValueContainerFactory.create(Describables.of((Object)"metadata of", (Object)projectIdentifier), context -> (LocalComponentGraphResolveState)factory.create()));
            valueContainer.finalizeIfNotAlready();
            return (LocalComponentGraphResolveState)valueContainer.get();
        }

        public void clear() {
            this.cache.clear();
        }
    }
}

